/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import net.alminoris.aestheticshelving.block.entity.LadderShelfBlockEntity;
import net.alminoris.aestheticshelving.block.entity.ModBlockEntities;
import net.alminoris.aestheticshelving.menu.LadderShelfMenu;
import net.alminoris.aestheticshelving.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LadderShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape BACK = LadderShelfBlock.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)28.0, (double)1.0);
    private static final VoxelShape FIRST = LadderShelfBlock.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)4.5, (double)12.75);
    private static final VoxelShape SECOND = LadderShelfBlock.box((double)2.0, (double)10.0, (double)0.0, (double)14.0, (double)11.5, (double)10.0);
    private static final VoxelShape THIRD = LadderShelfBlock.box((double)2.0, (double)17.0, (double)0.0, (double)14.0, (double)18.5, (double)7.0);
    private static final VoxelShape FOURTH = LadderShelfBlock.box((double)2.0, (double)24.0, (double)0.0, (double)14.0, (double)25.5, (double)4.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<LadderShelfBlock> CODEC = LadderShelfBlock.simpleCodec(LadderShelfBlock::new);

    public LadderShelfBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        boxes.add(BACK.bounds());
        boxes.add(FIRST.bounds());
        boxes.add(SECOND.bounds());
        boxes.add(THIRD.bounds());
        boxes.add(FOURTH.bounds());
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LadderShelfBlockEntity(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LadderShelfBlockEntity) {
                LadderShelfBlockEntity cupboard = (LadderShelfBlockEntity)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)cupboard);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos poss = blockEntity.getBlockPos();
                serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, pl) -> new LadderShelfMenu(containerId, inventory, (LadderShelfBlockEntity)blockEntity), (Component)state.getBlock().getName()), poss);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return LadderShelfBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.LADDER_SHELF_BLOCK_ENTITY.get()), (lvl, pos, st, be) -> be.tick(lvl, pos, st));
    }
}

