/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.block.entity;

import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ImplementedInventory
extends WorldlyContainer {
    public NonNullList<ItemStack> getItems();

    public static ImplementedInventory of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ImplementedInventory ofSize(int size) {
        return ImplementedInventory.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    default public int[] getSlotsForFace(Direction side) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    default public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
        return true;
    }

    default public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return true;
    }

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (ItemStack stack : this.getItems()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    default public void clearContent() {
        this.getItems().clear();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }
}

