/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.alminoris.aestheticshelving.block.custom.LadderShelfBlock;
import net.alminoris.aestheticshelving.block.entity.LadderShelfBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class LadderShelfBlockEntityRenderer
implements BlockEntityRenderer<LadderShelfBlockEntity> {
    public LadderShelfBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(LadderShelfBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        TreeMap<Integer, List<ItemStack>> oldStacks = entity.getRenderTreeMapStack();
        if (oldStacks.isEmpty() || entity.getLevel() == null) {
            return;
        }
        Direction facing = (Direction)entity.getBlockState().getValue((Property)LadderShelfBlock.FACING);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        switch (facing) {
            case NORTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        float[][] xArr = new float[][]{{0.375f, 0.625f}, {0.3f, 0.5f, 0.7f}, {0.35f, 0.35f, 0.65f, 0.65f}, {0.3f, 0.3f, 0.5f, 0.7f, 0.7f}};
        float[][] zArr = new float[][]{{0.15f, 0.15f}, {0.25f, 0.25f, 0.25f}, {0.5f, 0.25f, 0.25f, 0.5f}, {0.5f, 0.25f, 0.375f, 0.25f, 0.5f}};
        NavigableMap<Integer, List<ItemStack>> stacks = oldStacks.descendingMap();
        float[] yArr = new float[]{1.6575f, 1.225f, 0.7825f, 0.3525f};
        for (int i = 0; i < stacks.size(); ++i) {
            int j = 0;
            for (ItemStack stack : (List)stacks.get(i)) {
                poseStack.pushPose();
                poseStack.translate(xArr[i][j], !(stack.getItem() instanceof BlockItem) ? yArr[i] - 0.0525f : yArr[i], zArr[i][j]);
                poseStack.scale(0.2f, 0.2f, 0.2f);
                if (stack.getItem() instanceof BlockItem) {
                    poseStack.mulPose(Axis.YP.rotationDegrees(315.0f));
                    poseStack.mulPose(Axis.XP.rotationDegrees(330.0f));
                } else {
                    poseStack.mulPose(Axis.XP.rotationDegrees(270.0f));
                }
                itemRenderer.renderStatic(stack, ItemDisplayContext.GUI, this.getLightLevel(entity.getLevel(), entity.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, bufferSource, entity.getLevel(), 0);
                poseStack.popPose();
                ++j;
            }
        }
        poseStack.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)blockLight, (int)skyLight);
    }
}

