/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.alminoris.aestheticshelving.block.ModBlocks;
import net.alminoris.aestheticshelving.block.entity.TowerShelfBlockEntity;
import net.alminoris.aestheticshelving.menu.TowerShelfMenu;
import net.alminoris.aestheticshelving.util.helper.BlockSetsHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TowerShelfScreen
extends AbstractContainerScreen<TowerShelfMenu> {
    private final ResourceLocation TEXTURE;

    public TowerShelfScreen(TowerShelfMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        TowerShelfBlockEntity be;
        Container container = ((TowerShelfMenu)this.menu).getSlot((int)0).container;
        this.TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aestheticshelving", (String)("textures/gui/" + BlockSetsHelper.getWoodName(ModBlocks.TOWER_SHELVES, Objects.requireNonNull(container instanceof TowerShelfBlockEntity ? (be = (TowerShelfBlockEntity)container) : null)) + "_tower.png"));
    }

    protected void init() {
        super.init();
        this.titleLabelY = 10;
        this.titleLabelX = 10;
        this.inventoryLabelX = 10;
        this.inventoryLabelY = 80;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        TowerShelfBlockEntity be;
        Container container = ((TowerShelfMenu)this.menu).getSlot((int)0).container;
        TowerShelfBlockEntity blockEntity = Objects.requireNonNull(container instanceof TowerShelfBlockEntity ? (be = (TowerShelfBlockEntity)container) : null);
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, BlockSetsHelper.WOOD_COLORS.get(BlockSetsHelper.getWoodName(ModBlocks.TOWER_SHELVES, blockEntity)).intValue(), false);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, BlockSetsHelper.WOOD_COLORS.get(BlockSetsHelper.getWoodName(ModBlocks.TOWER_SHELVES, blockEntity)).intValue(), false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight + 12);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

