/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import net.alminoris.aestheticshelving.block.entity.ModBlockEntities;
import net.alminoris.aestheticshelving.block.entity.ShelfBlockEntity;
import net.alminoris.aestheticshelving.util.helper.VoxelShapeHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends class_2237
implements class_2343 {
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)6.0);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<Variant> VARIANT = class_2754.method_11850((String)"variant", Variant.class);
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.method_54094(ShelfBlock::new);

    public ShelfBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, VARIANT, WATERLOGGED});
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getRotatedShape(state);
    }

    private class_265 getRotatedShape(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        boxes.add(SHAPE.method_1107());
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ShelfBlockEntity(pos, state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        boolean waterlogged = ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2338 supportPos;
        class_2350 facing;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (direction == (facing = (class_2350)state.method_11654((class_2769)FACING)) && !world.method_8320(supportPos = pos.method_10093(facing)).method_26212((class_1922)world, supportPos)) {
            if (world instanceof class_1937) {
                class_1937 realWorld = (class_1937)world;
                realWorld.method_22352(pos, true);
            }
            return class_2246.field_10124.method_9564();
        }
        return this.updateShelfVariant(state, world, pos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof ShelfBlockEntity) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((ShelfBlockEntity)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        ShelfBlockEntity screenHandlerFactory;
        if (!world.field_9236 && (screenHandlerFactory = (ShelfBlockEntity)world.method_8321(pos)) != null) {
            player.method_17355((class_3908)screenHandlerFactory);
        }
        return class_1269.field_5812;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return ShelfBlock.method_31618(type, ModBlockEntities.SHELF_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> blockEntity.tick(world1, pos, state1));
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        this.updateSurroundingShelves(world, pos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 supportPos = pos.method_10093(facing);
        return world.method_8320(supportPos).method_26212((class_1922)world, supportPos);
    }

    private void updateSurroundingShelves(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (!(neighborState.method_26204() instanceof ShelfBlock)) continue;
            world.method_8501(neighborPos, this.updateShelfVariant(neighborState, (class_1936)world, neighborPos));
        }
    }

    private class_2680 updateShelfVariant(class_2680 state, class_1936 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 leftPos = pos.method_10093(facing.method_10160());
        class_2338 rightPos = pos.method_10093(facing.method_10170());
        boolean leftConnected = this.isShelf(world, leftPos, facing);
        boolean rightConnected = this.isShelf(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (class_2680)state.method_11657(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isShelf(class_1936 world, class_2338 pos, class_2350 facing) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof ShelfBlock && state.method_11654((class_2769)FACING) == facing;
    }

    public static enum Variant implements class_3542
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

