/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.datagen;

import java.util.function.Consumer;
import net.alminoris.aestheticshelving.block.ModBlocks;
import net.alminoris.aestheticshelving.item.ModItemGroups;
import net.alminoris.aestheticshelving.util.helper.BlockSetsHelper;
import net.alminoris.aestheticshelving.util.helper.ModJsonHelper;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(DataGenerator pOutput) {
        super(pOutput);
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> recipeExporter) {
        for (String name : BlockSetsHelper.WOODS) {
            String blockName = name.equals("crimson") || name.equals("warped") ? "stem" : (name.equals("bamboo") ? "block" : "log");
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.withDefaultNamespace((String)("stripped_" + name + "_" + blockName)));
            Block block1 = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.withDefaultNamespace((String)(name + "_" + blockName)));
            this.registerShelf(recipeExporter, (Block)ModBlocks.SHELVES.get(name).get(), block1, block);
            this.registerStandingShelf(recipeExporter, (Block)ModBlocks.STANDING_SHELVES.get(name).get(), block1, block);
            this.registerCornerShelf(recipeExporter, (Block)ModBlocks.CORNER_SHELVES.get(name).get(), block1, block);
            this.registerTowerShelf(recipeExporter, (Block)ModBlocks.TOWER_SHELVES.get(name).get(), block1, block);
            this.registerLadderShelf(recipeExporter, (Block)ModBlocks.LADDER_SHELVES.get(name).get(), block1, block);
            this.registerCeilingShelf(recipeExporter, (Block)ModBlocks.CEILING_SHELVES.get(name).get(), block);
        }
        for (String name : ModItemGroups.AN_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "arborealnature:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : ModItemGroups.WF_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "wildfields:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : ModItemGroups.WT_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "whisperleaftrees:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : ModItemGroups.ST_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "silverwoodtrees:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : ModItemGroups.MT_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "missingtrees:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : ModItemGroups.NSS_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"# #\",", "\"///\"", "");
        }
    }

    private void registerShelf(Consumer<FinishedRecipe> recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126130_("#/#").m_126127_(Character.valueOf('#'), (ItemLike)ing1).m_126127_(Character.valueOf('/'), (ItemLike)ing2).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing1), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing1)).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing2), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing2)).m_176498_(recipeExporter);
    }

    private void registerStandingShelf(Consumer<FinishedRecipe> recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126130_("/#").m_126130_("/#").m_126127_(Character.valueOf('#'), (ItemLike)ing1).m_126127_(Character.valueOf('/'), (ItemLike)ing2).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing1), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing1)).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing2), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing2)).m_176498_(recipeExporter);
    }

    private void registerCornerShelf(Consumer<FinishedRecipe> recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126130_("#/").m_126130_(" #").m_126127_(Character.valueOf('#'), (ItemLike)ing1).m_126127_(Character.valueOf('/'), (ItemLike)ing2).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing1), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing1)).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing2), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing2)).m_176498_(recipeExporter);
    }

    private void registerTowerShelf(Consumer<FinishedRecipe> recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)3).m_126130_(" / ").m_126130_("/#/").m_126130_("/#/").m_126127_(Character.valueOf('#'), (ItemLike)ing1).m_126127_(Character.valueOf('/'), (ItemLike)ing2).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing1), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing1)).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing2), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing2)).m_176498_(recipeExporter);
    }

    private void registerLadderShelf(Consumer<FinishedRecipe> recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)2).m_126130_("#/ ").m_126130_("#/ ").m_126130_(" #/").m_126127_(Character.valueOf('#'), (ItemLike)ing1).m_126127_(Character.valueOf('/'), (ItemLike)ing2).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing1), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing1)).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing2), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing2)).m_176498_(recipeExporter);
    }

    private void registerCeilingShelf(Consumer<FinishedRecipe> recipeExporter, Block output, Block ing2) {
        ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126130_("# #").m_126130_("///").m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50184_).m_126127_(Character.valueOf('/'), (ItemLike)ing2).m_142284_(ModRecipeProvider.m_176602_((ItemLike)Blocks.f_50184_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Blocks.f_50184_)).m_142284_(ModRecipeProvider.m_176602_((ItemLike)ing2), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ing2)).m_176498_(recipeExporter);
    }
}

