/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.attributecore.event;

import com.everydayxp.attributecore.init.AttributeInit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="attributecore")
public class AoEHealingHandler {
    private static final int HEAL_INTERVAL = 20;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance aoeAttrib = player.m_21051_((Attribute)AttributeInit.AOE_HEALING.get());
        if (aoeAttrib == null || aoeAttrib.m_22135_() <= 0.0) {
            return;
        }
        double aoeValue = aoeAttrib.m_22135_();
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        double radius = 3.0;
        AABB range = player.m_20191_().m_82400_(radius);
        for (LivingEntity nearby : player.m_9236_().m_45976_(LivingEntity.class, range)) {
            if (nearby == player || !AoEHealingHandler.isAlly(nearby)) continue;
            float healAmount = (float)(2.0 * aoeValue);
            nearby.m_5634_(healAmount);
        }
    }

    private static boolean isAlly(LivingEntity entity) {
        if (entity instanceof Player) {
            return true;
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            return tamable.m_21824_() && tamable.m_269323_() != null;
        }
        return false;
    }
}

