/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.attributecore.event;

import com.everydayxp.attributecore.init.AttributeInit;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PetAttributeEvents {
    private static final UUID PET_SPEED_UUID = UUID.fromString("12e1e683-7f97-44d8-92ca-5ee694ccbccb");

    @SubscribeEvent
    public static void onPetAttack(LivingDamageEvent event) {
        Player owner;
        AttributeInstance attr;
        TamableAnimal pet;
        LivingEntity livingEntity;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof TamableAnimal && (livingEntity = (pet = (TamableAnimal)entity).m_269323_()) instanceof Player && (attr = (owner = (Player)livingEntity).m_21051_((Attribute)AttributeInit.PET_DAMAGE.get())) != null) {
            double bonusPercent = attr.m_22135_();
            event.setAmount((float)((double)event.getAmount() * (1.0 + bonusPercent)));
        }
    }

    @SubscribeEvent
    public static void onPetHurt(LivingHurtEvent event) {
        Player owner;
        AttributeInstance attr;
        TamableAnimal pet;
        LivingEntity livingEntity;
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof TamableAnimal && (livingEntity = (pet = (TamableAnimal)livingEntity2).m_269323_()) instanceof Player && (attr = (owner = (Player)livingEntity).m_21051_((Attribute)AttributeInit.PET_RESISTANCE.get())) != null) {
            double resistance = attr.m_22135_();
            event.setAmount((float)((double)event.getAmount() * (1.0 - resistance)));
        }
    }

    @SubscribeEvent
    public static void onPetTick(LivingEvent.LivingTickEvent event) {
        TamableAnimal pet;
        LivingEntity livingEntity;
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof TamableAnimal && (livingEntity = (pet = (TamableAnimal)livingEntity2).m_269323_()) instanceof Player) {
            Player owner = (Player)livingEntity;
            AttributeInstance moveSpeed = pet.m_21051_(Attributes.f_22279_);
            AttributeInstance ownerSpeed = owner.m_21051_((Attribute)AttributeInit.PET_SPEED.get());
            if (moveSpeed != null && ownerSpeed != null) {
                moveSpeed.m_22120_(PET_SPEED_UUID);
                double bonus = ownerSpeed.m_22135_();
                if (bonus > 0.0) {
                    AttributeModifier bonusMod = new AttributeModifier(PET_SPEED_UUID, "pet_speed_from_owner", bonus, AttributeModifier.Operation.ADDITION);
                    moveSpeed.m_22118_(bonusMod);
                }
            }
        }
    }
}

