/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.attributecore.util;

import java.util.HashMap;
import java.util.Map;

public class CooldownManager {
    private final Map<String, Long> cooldowns = new HashMap<String, Long>();

    public void startCooldown(String id, long durationMs) {
        long cooldownEnd = System.currentTimeMillis() + durationMs;
        this.cooldowns.put(id, cooldownEnd);
    }

    public boolean isOnCooldown(String id) {
        Long endTime = this.cooldowns.get(id);
        if (endTime == null) {
            return false;
        }
        return System.currentTimeMillis() < endTime;
    }

    public long getRemainingTime(String id) {
        Long endTime = this.cooldowns.get(id);
        if (endTime == null) {
            return 0L;
        }
        long remaining = endTime - System.currentTimeMillis();
        return Math.max(remaining, 0L);
    }

    public void clearCooldown(String id) {
        this.cooldowns.remove(id);
    }

    public void clearAll() {
        this.cooldowns.clear();
    }
}

