/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.attributecore.event;

import com.everydayxp.attributecore.init.AttributeInit;
import java.util.WeakHashMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="attributecore")
public class GoldenGuardHandler {
    private static final WeakHashMap<Player, Integer> lastDamageTick = new WeakHashMap();
    private static final WeakHashMap<Player, Integer> lastRegenTick = new WeakHashMap();
    private static final int OUT_OF_COMBAT_TICKS = 160;
    private static final int REGEN_ABSORPTION_TICKS = 100;
    private static final int MIN_ABSORPTION = 4;
    private static final int MAX_ABSORPTION = 20;

    public static int getGoldenGuardCorazones(Player player) {
        AttributeInstance guardAttrib = player.m_21051_((Attribute)AttributeInit.GOLDEN_GUARD.get());
        if (guardAttrib == null || guardAttrib.m_22135_() <= 0.0) {
            return 0;
        }
        return Math.max(2, Math.min((int)Math.round(guardAttrib.m_22135_()), 10));
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            lastDamageTick.put(player, player.f_19797_);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        int maxCorazones = GoldenGuardHandler.getGoldenGuardCorazones(player);
        if (maxCorazones <= 0) {
            return;
        }
        int maxAbsorptionHP = maxCorazones * 2;
        int lastTick = lastDamageTick.getOrDefault(player, -1000);
        int ticksSinceDamage = player.f_19797_ - lastTick;
        if (ticksSinceDamage >= 160) {
            int lastRegen = lastRegenTick.getOrDefault(player, -1000);
            if (player.m_6103_() < (float)maxAbsorptionHP && player.f_19797_ - lastRegen >= 100) {
                player.m_7911_(Math.min(player.m_6103_() + 2.0f, (float)maxAbsorptionHP));
                lastRegenTick.put(player, player.f_19797_);
            }
        } else {
            lastRegenTick.remove(player);
        }
    }
}

