/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagFilter;
import com.gregtechceu.gtceu.utils.TagExprFilter;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TagFluidFilter
extends TagFilter<FluidStack, FluidFilter>
implements FluidFilter {
    private final Object2BooleanMap<Fluid> cache = new Object2BooleanOpenHashMap();

    protected TagFluidFilter() {
    }

    public static TagFluidFilter loadFilter(ItemStack itemStack) {
        return TagFluidFilter.loadFilter(Objects.requireNonNullElseGet(itemStack.getTag(), CompoundTag::new), filter -> itemStack.setTag(filter.saveFilter()));
    }

    private static TagFluidFilter loadFilter(CompoundTag tag, Consumer<FluidFilter> itemWriter) {
        TagFluidFilter handler = new TagFluidFilter();
        handler.itemWriter = itemWriter;
        handler.oreDictFilterExpression = tag.getString("oreDict");
        handler.matchExpr = null;
        handler.cache.clear();
        handler.matchExpr = TagExprFilter.parseExpression(handler.oreDictFilterExpression);
        return handler;
    }

    @Override
    public void setOreDict(String oreDict) {
        this.cache.clear();
        super.setOreDict(oreDict);
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        if (this.oreDictFilterExpression.isEmpty()) {
            return false;
        }
        if (this.cache.containsKey((Object)fluidStack.getFluid())) {
            return this.cache.getOrDefault((Object)fluidStack.getFluid(), false);
        }
        if (TagExprFilter.tagsMatch(this.matchExpr, fluidStack)) {
            this.cache.put((Object)fluidStack.getFluid(), true);
            return true;
        }
        this.cache.put((Object)fluidStack.getFluid(), false);
        return false;
    }

    @Override
    public int testFluidAmount(FluidStack fluidStack) {
        return this.test(fluidStack) ? Integer.MAX_VALUE : 0;
    }

    @Override
    public boolean supportsAmounts() {
        return false;
    }
}

