/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.GTBucketItem;
import com.gregtechceu.gtceu.api.item.TagPrefixItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class HazardProperty
implements IMaterialProperty {
    public final MedicalCondition condition;
    public final HazardTrigger hazardTrigger;
    public final boolean applyToDerivatives;
    public final float progressionMultiplier;

    public HazardProperty(HazardTrigger hazardTrigger, MedicalCondition condition, float progressionMultiplier, boolean applyToDerivatives) {
        this.hazardTrigger = hazardTrigger;
        this.condition = condition;
        this.applyToDerivatives = applyToDerivatives;
        this.progressionMultiplier = progressionMultiplier;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
    }

    public static Material getValidHazardMaterial(ItemStack item) {
        Material material = GTMaterials.NULL;
        TagPrefix prefix = TagPrefix.NULL_PREFIX;
        boolean isFluid = false;
        Item item2 = item.getItem();
        if (item2 instanceof TagPrefixItem) {
            TagPrefixItem prefixItem = (TagPrefixItem)item2;
            material = prefixItem.material;
            prefix = prefixItem.tagPrefix;
        } else {
            MaterialEntry entry;
            item2 = item.getItem();
            if (item2 instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item2;
                if (ConfigHolder.INSTANCE.gameplay.universalHazards || bucket instanceof GTBucketItem) {
                    material = ChemicalHelper.getMaterial(bucket.getFluid());
                    isFluid = true;
                }
            } else if (ConfigHolder.INSTANCE.gameplay.universalHazards && !(entry = ChemicalHelper.getMaterialEntry((ItemLike)item.getItem())).isEmpty()) {
                material = entry.material();
                prefix = entry.tagPrefix();
            }
        }
        HazardProperty property = material.getProperty(PropertyKey.HAZARD);
        if (property == null) {
            return GTMaterials.NULL;
        }
        if (!isFluid && !property.hazardTrigger.isAffected(prefix)) {
            return GTMaterials.NULL;
        }
        return material;
    }

    public record HazardTrigger(String name, ProtectionType protectionType, Set<TagPrefix> affectedTagPrefixes) implements StringRepresentable
    {
        public static final Map<String, HazardTrigger> ALL_TRIGGERS = new HashMap<String, HazardTrigger>();
        public static final HazardTrigger INHALATION = new HazardTrigger("inhalation", ProtectionType.MASK, TagPrefix.dust, TagPrefix.dustSmall, TagPrefix.dustTiny, TagPrefix.dustPure, TagPrefix.dustImpure);
        public static final HazardTrigger ANY = new HazardTrigger("any", ProtectionType.FULL, new TagPrefix[0]);
        public static final HazardTrigger SKIN_CONTACT = new HazardTrigger("skin_contact", ProtectionType.HANDS, TagPrefix.dust, TagPrefix.dustSmall, TagPrefix.dustTiny);
        public static final HazardTrigger NONE = new HazardTrigger("none", ProtectionType.NONE, new TagPrefix[0]);

        public HazardTrigger(String name, ProtectionType protectionType, Set<TagPrefix> affectedTagPrefixes) {
            ALL_TRIGGERS.put(name, this);
            this.name = name;
            this.protectionType = protectionType;
            this.affectedTagPrefixes = affectedTagPrefixes;
        }

        public HazardTrigger(String name, ProtectionType protectionType, TagPrefix ... tagPrefixes) {
            this(name, protectionType, new HashSet<TagPrefix>());
            this.affectedTagPrefixes.addAll(Arrays.asList(tagPrefixes));
        }

        public boolean isAffected(TagPrefix prefix) {
            if (this.affectedTagPrefixes.isEmpty()) {
                return true;
            }
            return this.affectedTagPrefixes.contains(prefix);
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum ProtectionType {
        MASK(Set.of("head"), ArmorItem.Type.HELMET),
        HANDS(Set.of("hands"), ArmorItem.Type.CHESTPLATE),
        FULL(Set.of(), ArmorItem.Type.BOOTS, ArmorItem.Type.HELMET, ArmorItem.Type.CHESTPLATE, ArmorItem.Type.LEGGINGS),
        NONE(Set.of(), new ArmorItem.Type[0]);

        private final Set<ArmorItem.Type> equipmentTypes;
        private final Set<String> curioSlots;

        private ProtectionType(Set<String> curioSlots, ArmorItem.Type ... equipmentTypes) {
            this.curioSlots = curioSlots;
            this.equipmentTypes = Set.of(equipmentTypes);
        }

        public boolean isProtected(LivingEntity livingEntity) {
            if (this == NONE) {
                return true;
            }
            HashSet<ArmorItem.Type> correctArmorItems = new HashSet<ArmorItem.Type>();
            for (ArmorItem.Type equipmentType : this.equipmentTypes) {
                ArmorComponentItem armorItem;
                Item item;
                ItemStack armor = livingEntity.getItemBySlot(equipmentType.getSlot());
                if (armor.isEmpty() || (!((item = armor.getItem()) instanceof ArmorComponentItem) || !(armorItem = (ArmorComponentItem)item).getArmorLogic().isPPE()) && !armor.getTags().anyMatch(tag -> tag.equals(CustomTags.PPE_ARMOR))) continue;
                correctArmorItems.add(equipmentType);
            }
            if (!GTCEu.Mods.isCuriosLoaded() || this.curioSlots.isEmpty()) {
                return correctArmorItems.containsAll(this.equipmentTypes);
            }
            HashSet<String> correctCurios = new HashSet<String>();
            ICuriosItemHandler curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)livingEntity).resolve().orElse(null);
            if (curiosInventory == null) {
                return correctArmorItems.containsAll(this.equipmentTypes);
            }
            List results = curiosInventory.findCurios((String[])this.curioSlots.toArray(String[]::new));
            for (SlotResult result : results) {
                ArmorComponentItem armorItem;
                Item item;
                ItemStack armor = result.stack();
                if (armor.isEmpty() || (!((item = armor.getItem()) instanceof ArmorComponentItem) || !(armorItem = (ArmorComponentItem)item).getArmorLogic().isPPE()) && !armor.getTags().anyMatch(tag -> tag.equals(CustomTags.PPE_ARMOR))) continue;
                correctCurios.add(result.slotContext().identifier());
            }
            return correctArmorItems.containsAll(this.equipmentTypes) || correctCurios.containsAll(this.curioSlots);
        }

        public void damageEquipment(Player player, int amount) {
            if (player.level().getGameTime() % 100L == 0L) {
                ICuriosItemHandler curiosInventory;
                for (ArmorItem.Type type : this.getEquipmentTypes()) {
                    ArmorComponentItem armorItem;
                    Item item;
                    ItemStack armor = player.getItemBySlot(type.getSlot());
                    if (armor.isEmpty() || (!((item = armor.getItem()) instanceof ArmorComponentItem) || !(armorItem = (ArmorComponentItem)item).getArmorLogic().isPPE()) && !armor.getTags().anyMatch(tag -> tag.equals(CustomTags.PPE_ARMOR))) continue;
                    armor.hurtAndBreak(amount, (LivingEntity)player, p -> p.broadcastBreakEvent(type.getSlot()));
                }
                if (GTCEu.Mods.isCuriosLoaded() && (curiosInventory = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).resolve().orElse(null)) != null) {
                    for (String curioItem : this.getCurioSlots()) {
                        curiosInventory.getStacksHandler(curioItem).ifPresent(handler -> {
                            IDynamicStackHandler stackHandler = handler.getStacks();
                            for (int i = 0; i < handler.getSlots(); ++i) {
                                ArmorComponentItem armorItem;
                                Item patt7901$temp;
                                ItemStack armor = stackHandler.getStackInSlot(i);
                                if (armor.isEmpty() || (!((patt7901$temp = armor.getItem()) instanceof ArmorComponentItem) || !(armorItem = (ArmorComponentItem)patt7901$temp).getArmorLogic().isPPE()) && !armor.getTags().anyMatch(tag -> tag.equals(CustomTags.PPE_ARMOR))) continue;
                                armor.hurtAndBreak(amount, (LivingEntity)player, p -> {});
                            }
                        });
                    }
                }
            }
        }

        @Generated
        public Set<ArmorItem.Type> getEquipmentTypes() {
            return this.equipmentTypes;
        }

        @Generated
        public Set<String> getCurioSlots() {
            return this.curioSlots;
        }
    }
}

