/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreVeinWorldEntry {
    @Nullable
    private BedrockOreDefinition definition;
    private int oreYield;
    private int operationsRemaining;

    public OreVeinWorldEntry(@Nullable BedrockOreDefinition vein, int oreYield, int operationsRemaining) {
        this.definition = vein;
        this.oreYield = oreYield;
        this.operationsRemaining = operationsRemaining;
    }

    private OreVeinWorldEntry() {
    }

    public void setOperationsRemaining(int amount) {
        this.operationsRemaining = amount;
    }

    public void decreaseOperations(int amount) {
        this.operationsRemaining = ConfigHolder.INSTANCE.worldgen.oreVeins.infiniteBedrockOresFluids ? this.operationsRemaining : Math.max(0, this.operationsRemaining - amount);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("oreYield", this.oreYield);
        tag.putInt("operationsRemaining", this.operationsRemaining);
        if (this.definition != null && GTRegistries.BEDROCK_ORE_DEFINITIONS.getKey(this.definition) != null) {
            tag.putString("vein", ((ResourceLocation)GTRegistries.BEDROCK_ORE_DEFINITIONS.getKey(this.definition)).toString());
        }
        return tag;
    }

    @NotNull
    public static OreVeinWorldEntry readFromNBT(@NotNull CompoundTag tag) {
        ResourceLocation id;
        OreVeinWorldEntry info = new OreVeinWorldEntry();
        info.oreYield = tag.getInt("oreYield");
        info.operationsRemaining = tag.getInt("operationsRemaining");
        if (tag.contains("vein") && GTRegistries.BEDROCK_ORE_DEFINITIONS.containKey(id = new ResourceLocation(tag.getString("vein")))) {
            info.definition = (BedrockOreDefinition)GTRegistries.BEDROCK_ORE_DEFINITIONS.get(id);
        }
        return info;
    }

    @Nullable
    @Generated
    public BedrockOreDefinition getDefinition() {
        return this.definition;
    }

    @Generated
    public int getOreYield() {
        return this.oreYield;
    }

    @Generated
    public int getOperationsRemaining() {
        return this.operationsRemaining;
    }
}

