/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.GeodeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class GeodeVeinGenerator
extends VeinGenerator {
    private static final Direction[] DIRECTIONS = Direction.values();
    public static final Codec<Double> CHANCE_RANGE = Codec.doubleRange((double)0.0, (double)1.0);
    public static final Codec<GeodeVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GeodeBlockSettings.CODEC.fieldOf("blocks").forGetter(config -> config.geodeBlockSettings), (App)GeodeLayerSettings.CODEC.fieldOf("layers").forGetter(config -> config.geodeLayerSettings), (App)GeodeCrackSettings.CODEC.fieldOf("crack").forGetter(config -> config.geodeCrackSettings), (App)CHANCE_RANGE.fieldOf("use_potential_placements_chance").orElse((Object)0.35).forGetter(config -> config.usePotentialPlacementsChance), (App)CHANCE_RANGE.fieldOf("use_alternate_layer0_chance").orElse((Object)0.0).forGetter(config -> config.useAlternateLayer0Chance), (App)Codec.BOOL.fieldOf("placements_require_layer0_alternate").orElse((Object)true).forGetter(config -> config.placementsRequireLayer0Alternate), (App)IntProvider.codec((int)1, (int)20).fieldOf("outer_wall_distance").orElse((Object)UniformInt.of((int)4, (int)5)).forGetter(config -> config.outerWallDistance), (App)IntProvider.codec((int)1, (int)20).fieldOf("distribution_points").orElse((Object)UniformInt.of((int)3, (int)4)).forGetter(config -> config.distributionPoints), (App)IntProvider.codec((int)0, (int)10).fieldOf("point_offset").orElse((Object)UniformInt.of((int)1, (int)2)).forGetter(config -> config.pointOffset), (App)Codec.INT.fieldOf("min_gen_offset").orElse((Object)-16).forGetter(config -> config.minGenOffset), (App)Codec.INT.fieldOf("max_gen_offset").orElse((Object)16).forGetter(config -> config.maxGenOffset), (App)CHANCE_RANGE.fieldOf("noise_multiplier").orElse((Object)0.05).forGetter(config -> config.noiseMultiplier), (App)Codec.INT.fieldOf("invalid_blocks_threshold").forGetter(config -> config.invalidBlocksThreshold)).apply((Applicative)instance, GeodeVeinGenerator::new));
    public GeodeBlockSettings geodeBlockSettings;
    public GeodeLayerSettings geodeLayerSettings;
    public GeodeCrackSettings geodeCrackSettings;
    public double usePotentialPlacementsChance = 0.5;
    public double useAlternateLayer0Chance = 0.0;
    public boolean placementsRequireLayer0Alternate = false;
    public IntProvider outerWallDistance = ConstantInt.of((int)0);
    public IntProvider distributionPoints = ConstantInt.of((int)0);
    public IntProvider pointOffset = ConstantInt.of((int)0);
    public int minGenOffset = 0;
    public int maxGenOffset = 0;
    public double noiseMultiplier = 1.0;
    public int invalidBlocksThreshold = 0;

    public GeodeVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    @Override
    public List<VeinGenerator.VeinEntry> getAllEntries() {
        LegacyRandomSource source = new LegacyRandomSource(0L);
        return List.of(new VeinGenerator.VeinEntry((Either<BlockState, Material>)this.geodeBlockSettings.fillingProvider.mapLeft(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$14((RandomSource)source, arg_0)), 1), new VeinGenerator.VeinEntry((Either<BlockState, Material>)this.geodeBlockSettings.innerLayerProvider.mapLeft(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$15((RandomSource)source, arg_0)), 1), new VeinGenerator.VeinEntry((Either<BlockState, Material>)this.geodeBlockSettings.alternateInnerLayerProvider.mapLeft(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$16((RandomSource)source, arg_0)), 1), new VeinGenerator.VeinEntry((Either<BlockState, Material>)this.geodeBlockSettings.middleLayerProvider.mapLeft(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$17((RandomSource)source, arg_0)), 1), new VeinGenerator.VeinEntry((Either<BlockState, Material>)this.geodeBlockSettings.outerLayerProvider.mapLeft(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$18((RandomSource)source, arg_0)), 1));
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        BlockState blockState;
        int offset;
        int offset2;
        BulkSectionAccess access = new BulkSectionAccess((LevelAccessor)level);
        int minOffset = this.minGenOffset;
        int maxOffset = this.maxGenOffset;
        int distributionSample = this.distributionPoints.sample(random);
        ArrayList<ObjectIntPair> points = new ArrayList<ObjectIntPair>(distributionSample);
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.getSeed()));
        NormalNoise normalNoise = NormalNoise.create((RandomSource)worldgenRandom, (int)-4, (double[])new double[]{1.0});
        ArrayList<BlockPos> list2 = new ArrayList<BlockPos>(3);
        double wallDistance = (double)distributionSample / (double)this.outerWallDistance.getMaxValue();
        double fillingSize = 1.0 / Math.sqrt(this.geodeLayerSettings.filling);
        double innerSize = 1.0 / Math.sqrt(this.geodeLayerSettings.innerLayer + wallDistance);
        double middleSize = 1.0 / Math.sqrt(this.geodeLayerSettings.middleLayer + wallDistance);
        double outerSize = 1.0 / Math.sqrt(this.geodeLayerSettings.outerLayer + wallDistance);
        double crackSize = 1.0 / Math.sqrt(this.geodeCrackSettings.baseCrackSize + random.nextDouble() / 2.0 + (distributionSample > 3 ? wallDistance : 0.0));
        boolean doCrack = (double)random.nextFloat() < this.geodeCrackSettings.generateCrackChance;
        int invalidBlocksCount = 0;
        for (offset2 = 0; offset2 < distributionSample; ++offset2) {
            offset = this.outerWallDistance.sample(random);
            BlockPos origin2 = origin.offset(offset, this.outerWallDistance.sample(random), this.outerWallDistance.sample(random));
            blockState = access.getBlockState(origin2);
            if ((blockState.isAir() || blockState.is(BlockTags.GEODE_INVALID_BLOCKS)) && ++invalidBlocksCount > this.invalidBlocksThreshold) {
                return Map.of();
            }
            points.add(ObjectIntPair.of((Object)origin2, (int)this.pointOffset.sample(random)));
        }
        if (doCrack) {
            offset2 = random.nextInt(4);
            offset = distributionSample * 2 + 1;
            if (offset2 == 0) {
                list2.add(origin.offset(offset, 7, 0));
                list2.add(origin.offset(offset, 5, 0));
                list2.add(origin.offset(offset, 1, 0));
            } else if (offset2 == 1) {
                list2.add(origin.offset(0, 7, offset));
                list2.add(origin.offset(0, 5, offset));
                list2.add(origin.offset(0, 1, offset));
            } else if (offset2 == 2) {
                list2.add(origin.offset(offset, 7, offset));
                list2.add(origin.offset(offset, 5, offset));
                list2.add(origin.offset(offset, 1, offset));
            } else {
                list2.add(origin.offset(0, 7, 0));
                list2.add(origin.offset(0, 5, 0));
                list2.add(origin.offset(0, 1, 0));
            }
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        Predicate placementPredicate = GeodeFeature.isReplaceable(this.geodeBlockSettings.cannotReplace);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)origin.offset(minOffset, minOffset, minOffset), (BlockPos)origin.offset(maxOffset, maxOffset, maxOffset))) {
            LevelChunkSection section;
            double noiseValue = normalNoise.getValue((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) * this.noiseMultiplier;
            double s = 0.0;
            double t = 0.0;
            for (ObjectIntPair pair : points) {
                s += Mth.invSqrt((double)(pos.distSqr((Vec3i)pair.first()) + (double)pair.secondInt())) + noiseValue;
            }
            for (Direction[] origin4 : list2) {
                t += Mth.invSqrt((double)(pos.distSqr((Vec3i)origin4) + (double)this.geodeCrackSettings.crackPointOffset)) + noiseValue;
            }
            if (s < outerSize || !level.ensureCanWrite(pos) || (section = access.getSection(pos)) == null) continue;
            if (doCrack && t >= crackSize && s < fillingSize) {
                this.safeSetBlock(access, section, pos, Blocks.AIR.defaultBlockState(), placementPredicate);
                for (Direction direction : DIRECTIONS) {
                    BlockPos origin5 = pos.relative(direction);
                    FluidState fluidState = level.getFluidState(origin5);
                    if (fluidState.isEmpty()) continue;
                    level.scheduleTick(origin5, fluidState.getType(), 0);
                }
                continue;
            }
            if (s >= fillingSize) {
                this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.fillingProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                continue;
            }
            if (s >= innerSize) {
                boolean useAltLayer;
                boolean bl = useAltLayer = (double)random.nextFloat() < this.useAlternateLayer0Chance;
                if (useAltLayer) {
                    this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.alternateInnerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                } else {
                    this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.innerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                }
                if (this.placementsRequireLayer0Alternate && !useAltLayer || !((double)random.nextFloat() < this.usePotentialPlacementsChance)) continue;
                positions.add(pos.immutable());
                continue;
            }
            if (s >= middleSize) {
                this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.middleLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                continue;
            }
            if (!(s >= outerSize)) continue;
            this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.outerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
        }
        List<BlockState> innerPlacements = this.geodeBlockSettings.innerPlacements;
        block5: for (BlockPos origin2 : positions) {
            blockState = (BlockState)Util.getRandom(innerPlacements, (RandomSource)random);
            for (Direction direction2 : DIRECTIONS) {
                LevelChunkSection section;
                if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.FACING, (Comparable)direction2);
                }
                BlockPos origin6 = origin2.relative(direction2);
                BlockState blockState2 = access.getBlockState(origin6);
                if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(blockState2.getFluidState().isSource()));
                }
                if (!BuddingAmethystBlock.canClusterGrowAtState((BlockState)blockState2) || !level.ensureCanWrite(origin6) || (section = access.getSection(origin6)) == null) continue;
                this.safeSetBlock(access, section, origin6, blockState, placementPredicate);
                continue block5;
            }
        }
        access.close();
        return Map.of();
    }

    protected void safeSetBlock(BulkSectionAccess level, LevelChunkSection section, BlockPos pos, BlockState state, Predicate<BlockState> oldState) {
        if (oldState.test(level.getBlockState(pos))) {
            int x = SectionPos.sectionRelative((int)pos.getX());
            int y = SectionPos.sectionRelative((int)pos.getY());
            int z = SectionPos.sectionRelative((int)pos.getZ());
            section.setBlockState(x, y, z, state, false);
        }
    }

    protected BlockState getStateFromEither(Either<BlockStateProvider, Material> either, GeodeBlockSettings settings, RandomSource random, BlockPos pos) {
        return (BlockState)either.map(provider -> provider.getState(random, pos), material -> ChemicalHelper.getBlock(settings.providerMaterialPrefix, material).defaultBlockState());
    }

    @Override
    public VeinGenerator build() {
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new GeodeVeinGenerator(this.geodeBlockSettings, this.geodeLayerSettings, this.geodeCrackSettings, this.usePotentialPlacementsChance, this.useAlternateLayer0Chance, this.placementsRequireLayer0Alternate, this.outerWallDistance, this.distributionPoints, this.pointOffset, this.minGenOffset, this.maxGenOffset, this.noiseMultiplier, this.invalidBlocksThreshold);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    @Generated
    public GeodeVeinGenerator(GeodeBlockSettings geodeBlockSettings, GeodeLayerSettings geodeLayerSettings, GeodeCrackSettings geodeCrackSettings, double usePotentialPlacementsChance, double useAlternateLayer0Chance, boolean placementsRequireLayer0Alternate, IntProvider outerWallDistance, IntProvider distributionPoints, IntProvider pointOffset, int minGenOffset, int maxGenOffset, double noiseMultiplier, int invalidBlocksThreshold) {
        this.geodeBlockSettings = geodeBlockSettings;
        this.geodeLayerSettings = geodeLayerSettings;
        this.geodeCrackSettings = geodeCrackSettings;
        this.usePotentialPlacementsChance = usePotentialPlacementsChance;
        this.useAlternateLayer0Chance = useAlternateLayer0Chance;
        this.placementsRequireLayer0Alternate = placementsRequireLayer0Alternate;
        this.outerWallDistance = outerWallDistance;
        this.distributionPoints = distributionPoints;
        this.pointOffset = pointOffset;
        this.minGenOffset = minGenOffset;
        this.maxGenOffset = maxGenOffset;
        this.noiseMultiplier = noiseMultiplier;
        this.invalidBlocksThreshold = invalidBlocksThreshold;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator geodeBlockSettings(GeodeBlockSettings geodeBlockSettings) {
        this.geodeBlockSettings = geodeBlockSettings;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator geodeLayerSettings(GeodeLayerSettings geodeLayerSettings) {
        this.geodeLayerSettings = geodeLayerSettings;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator geodeCrackSettings(GeodeCrackSettings geodeCrackSettings) {
        this.geodeCrackSettings = geodeCrackSettings;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator usePotentialPlacementsChance(double usePotentialPlacementsChance) {
        this.usePotentialPlacementsChance = usePotentialPlacementsChance;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator useAlternateLayer0Chance(double useAlternateLayer0Chance) {
        this.useAlternateLayer0Chance = useAlternateLayer0Chance;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator placementsRequireLayer0Alternate(boolean placementsRequireLayer0Alternate) {
        this.placementsRequireLayer0Alternate = placementsRequireLayer0Alternate;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator outerWallDistance(IntProvider outerWallDistance) {
        this.outerWallDistance = outerWallDistance;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator distributionPoints(IntProvider distributionPoints) {
        this.distributionPoints = distributionPoints;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator pointOffset(IntProvider pointOffset) {
        this.pointOffset = pointOffset;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator minGenOffset(int minGenOffset) {
        this.minGenOffset = minGenOffset;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator maxGenOffset(int maxGenOffset) {
        this.maxGenOffset = maxGenOffset;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator noiseMultiplier(double noiseMultiplier) {
        this.noiseMultiplier = noiseMultiplier;
        return this;
    }

    @NotNull
    @Generated
    public GeodeVeinGenerator invalidBlocksThreshold(int invalidBlocksThreshold) {
        this.invalidBlocksThreshold = invalidBlocksThreshold;
        return this;
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$18(RandomSource source, BlockStateProvider provider) {
        return provider.getState(source, BlockPos.ZERO);
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$17(RandomSource source, BlockStateProvider provider) {
        return provider.getState(source, BlockPos.ZERO);
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$16(RandomSource source, BlockStateProvider provider) {
        return provider.getState(source, BlockPos.ZERO);
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$15(RandomSource source, BlockStateProvider provider) {
        return provider.getState(source, BlockPos.ZERO);
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$14(RandomSource source, BlockStateProvider provider) {
        return provider.getState(source, BlockPos.ZERO);
    }

    public record GeodeBlockSettings(Either<BlockStateProvider, Material> fillingProvider, Either<BlockStateProvider, Material> innerLayerProvider, Either<BlockStateProvider, Material> alternateInnerLayerProvider, Either<BlockStateProvider, Material> middleLayerProvider, Either<BlockStateProvider, Material> outerLayerProvider, List<BlockState> innerPlacements, TagKey<Block> cannotReplace, TagKey<Block> invalidBlocks, @NotNull TagPrefix providerMaterialPrefix) {
        public static final Codec<GeodeBlockSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)BlockStateProvider.CODEC, GTCEuAPI.materialManager.codec()).fieldOf("filling_provider").forGetter(config -> config.fillingProvider), (App)Codec.either((Codec)BlockStateProvider.CODEC, GTCEuAPI.materialManager.codec()).fieldOf("inner_layer_provider").forGetter(config -> config.innerLayerProvider), (App)Codec.either((Codec)BlockStateProvider.CODEC, GTCEuAPI.materialManager.codec()).fieldOf("alternate_inner_layer_provider").forGetter(config -> config.alternateInnerLayerProvider), (App)Codec.either((Codec)BlockStateProvider.CODEC, GTCEuAPI.materialManager.codec()).fieldOf("middle_layer_provider").forGetter(config -> config.middleLayerProvider), (App)Codec.either((Codec)BlockStateProvider.CODEC, GTCEuAPI.materialManager.codec()).fieldOf("outer_layer_provider").forGetter(config -> config.outerLayerProvider), (App)ExtraCodecs.nonEmptyList((Codec)BlockState.CODEC.listOf()).fieldOf("inner_placements").forGetter(config -> config.innerPlacements), (App)TagKey.hashedCodec((ResourceKey)Registries.BLOCK).fieldOf("cannot_replace").forGetter(config -> config.cannotReplace), (App)TagKey.hashedCodec((ResourceKey)Registries.BLOCK).fieldOf("invalid_blocks").forGetter(config -> config.invalidBlocks), (App)TagPrefix.CODEC.optionalFieldOf("provider_material_prefix", (Object)TagPrefix.block).forGetter(config -> config.providerMaterialPrefix)).apply((Applicative)instance, GeodeBlockSettings::new));
    }
}

