/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids.store;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidStorageImpl
implements FluidStorage {
    private final Map<FluidStorageKey, FluidStorage.FluidEntry> map = new Object2ObjectOpenHashMap();
    private Map<FluidStorageKey, FluidBuilder> toRegister = new Object2ObjectOpenHashMap();
    private boolean registered = false;

    @Override
    public void enqueueRegistration(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
        if (this.registered) {
            throw new IllegalStateException("Cannot enqueue a builder after registration");
        }
        if (this.toRegister.containsKey(key)) {
            throw new IllegalArgumentException("FluidStorageKey " + String.valueOf(key) + " is already queued");
        }
        this.toRegister.put(key, builder);
    }

    @Override
    @Nullable
    public FluidBuilder getQueuedBuilder(@NotNull FluidStorageKey key) {
        if (this.registered) {
            throw new IllegalArgumentException("FluidStorage has already been registered");
        }
        return this.toRegister.get(key);
    }

    @ApiStatus.Internal
    public void registerFluids(@NotNull Material material, GTRegistrate registrate) {
        if (this.registered) {
            throw new IllegalStateException("FluidStorage has already been registered");
        }
        if (this.toRegister.isEmpty() && this.map.isEmpty()) {
            this.enqueueRegistration(FluidStorageKeys.LIQUID, new FluidBuilder());
        }
        this.toRegister.entrySet().stream().sorted(Comparator.comparingInt(e -> -((FluidStorageKey)e.getKey()).getRegistrationPriority())).forEach(entry -> {
            if (this.map.containsKey(entry.getKey())) {
                GTCEu.LOGGER.warn("{} already has an associated fluid for material {}", entry.getKey(), (Object)material);
                return;
            }
            Supplier<? extends Fluid> fluid = ((FluidBuilder)entry.getValue()).build(material, (FluidStorageKey)entry.getKey(), registrate);
            if (!this.storeNoOverwrites((FluidStorageKey)entry.getKey(), fluid, (FluidBuilder)entry.getValue())) {
                GTCEu.LOGGER.error("{} already has an associated fluid for material {}", (Object)material, (Object)material);
            }
        });
        this.toRegister = null;
        this.registered = true;
    }

    @Override
    @Nullable
    public Fluid get(@NotNull FluidStorageKey key) {
        return this.map.containsKey(key) ? this.map.get(key).getFluid().get() : null;
    }

    @Override
    @Nullable
    public FluidStorage.FluidEntry getEntry(@NotNull FluidStorageKey key) {
        return this.map.getOrDefault(key, null);
    }

    private boolean storeNoOverwrites(@NotNull FluidStorageKey key, @NotNull Supplier<? extends Fluid> fluid, @Nullable FluidBuilder builder) {
        if (this.map.containsKey(key)) {
            return false;
        }
        this.store(key, fluid, builder);
        return true;
    }

    @Override
    public void store(@NotNull FluidStorageKey key, @NotNull Supplier<? extends Fluid> fluid, @Nullable FluidBuilder builder) {
        if (this.map.containsKey(key)) {
            throw new IllegalArgumentException(String.valueOf(key) + " already has an associated fluid");
        }
        if (builder != null) {
            this.map.put(key, new FluidStorage.FluidEntry(fluid, builder));
        } else {
            this.map.put(key, new FluidStorage.FluidEntry(fluid, null));
        }
    }
}

