/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.editor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.gui.editor.IEditableUI;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class EditableMachineUI
implements IEditableUI<WidgetGroup, MetaMachine> {
    final String groupName;
    final ResourceLocation uiPath;
    final Supplier<WidgetGroup> widgetSupplier;
    final BiConsumer<WidgetGroup, MetaMachine> binder;
    @Nullable
    private CompoundTag customUICache;

    public EditableMachineUI(String groupName, ResourceLocation uiPath, Supplier<WidgetGroup> widgetSupplier, BiConsumer<WidgetGroup, MetaMachine> binder) {
        this.groupName = groupName;
        this.uiPath = uiPath;
        this.widgetSupplier = widgetSupplier;
        this.binder = binder;
    }

    @Override
    public WidgetGroup createDefault() {
        return this.widgetSupplier.get();
    }

    @Override
    public void setupUI(WidgetGroup template, MetaMachine machine) {
        this.binder.accept(template, machine);
    }

    @Nullable
    public WidgetGroup createCustomUI() {
        if (this.hasCustomUI()) {
            CompoundTag nbt = this.getCustomUI();
            WidgetGroup group = new WidgetGroup();
            IConfigurableWidget.deserializeNBT((IConfigurableWidget)group, (CompoundTag)nbt.getCompound("root"), (Resources)Resources.fromNBT((CompoundTag)nbt.getCompound("resources")), (boolean)false);
            group.setSelfPosition(new Position(0, 0));
            return group;
        }
        return null;
    }

    public CompoundTag getCustomUI() {
        if (this.customUICache == null) {
            ResourceManager resourceManager = null;
            if (GTCEu.isClientSide()) {
                resourceManager = Minecraft.getInstance().getResourceManager();
            } else if (GTCEu.getMinecraftServer() != null) {
                resourceManager = GTCEu.getMinecraftServer().getResourceManager();
            }
            if (resourceManager == null) {
                this.customUICache = new CompoundTag();
            } else {
                try {
                    Resource resource = resourceManager.getResourceOrThrow(new ResourceLocation(this.uiPath.getNamespace(), "ui/machine/%s.mui".formatted(this.uiPath.getPath())));
                    try (InputStream inputStream = resource.open();
                         DataInputStream dataInputStream = new DataInputStream(inputStream);){
                        this.customUICache = NbtIo.read((DataInput)dataInputStream, (NbtAccounter)NbtAccounter.UNLIMITED);
                    }
                }
                catch (Exception e) {
                    this.customUICache = new CompoundTag();
                }
                if (this.customUICache == null) {
                    this.customUICache = new CompoundTag();
                }
            }
        }
        return this.customUICache;
    }

    public boolean hasCustomUI() {
        return !this.getCustomUI().isEmpty();
    }

    public void reloadCustomUI() {
        this.customUICache = null;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public ResourceLocation getUiPath() {
        return this.uiPath;
    }
}

