/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.factory;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.lowdragmc.lowdraglib.gui.factory.UIFactory;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CoverUIFactory
extends UIFactory<CoverBehavior> {
    public static final CoverUIFactory INSTANCE = new CoverUIFactory();

    public CoverUIFactory() {
        super(GTCEu.id("cover"));
    }

    protected ModularUI createUITemplate(CoverBehavior holder, Player entityPlayer) {
        if (holder instanceof IUICover) {
            IUICover cover = (IUICover)((Object)holder);
            return cover.createUI(entityPlayer);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected CoverBehavior readHolderFromSyncData(FriendlyByteBuf syncData) {
        Direction side;
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return null;
        }
        BlockPos pos = syncData.readBlockPos();
        ICoverable coverable = GTCapabilityHelper.getCoverable((Level)world, pos, side = (Direction)syncData.readEnum(Direction.class));
        if (coverable != null) {
            return coverable.getCoverAtSide(side);
        }
        return null;
    }

    protected void writeHolderToSyncData(FriendlyByteBuf syncData, CoverBehavior holder) {
        syncData.writeBlockPos(holder.coverHolder.getPos());
        syncData.writeEnum((Enum)holder.attachedSide);
    }
}

