/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.misc;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.OreVeinWorldEntry;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.WeightedMaterial;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public abstract class ProspectorMode<T> {
    public static ProspectorMode<String> ORE = new ProspectorMode<String>("metaitem.prospector.mode.ores", 16){
        private final Map<BlockState, String> BLOCK_CACHE = new HashMap<BlockState, String>();
        private final Map<String, IGuiTexture> ICON_CACHE = new HashMap<String, IGuiTexture>();

        public void scan(String[][][] storage, LevelChunk chunk) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            TagKey<Block> oreTag = TagUtil.createBlockTag("ores");
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = chunk.getMaxBuildHeight() - 1; y >= chunk.getMinBuildHeight(); --y) {
                        pos.set(x, y, z);
                        BlockState state = chunk.getBlockState((BlockPos)pos);
                        if (!state.is(oreTag)) continue;
                        String itemName = this.BLOCK_CACHE.computeIfAbsent(state, blockState -> {
                            Object name = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString();
                            MaterialEntry entry = ChemicalHelper.getMaterialEntry((ItemLike)blockState.getBlock());
                            if (!entry.isEmpty()) {
                                name = "material_" + String.valueOf(entry.material());
                            }
                            return name;
                        });
                        storage[x][z] = (String[])ArrayUtils.add((Object[])storage[x][z], (Object)itemName);
                    }
                }
            }
        }

        @Override
        public int getItemColor(String item) {
            Material mat;
            if (item.startsWith("material_") && !(mat = GTMaterials.get(item.substring(9))).isNull()) {
                return mat.getMaterialRGB();
            }
            return ((Block)BuiltInRegistries.BLOCK.get((ResourceLocation)new ResourceLocation((String)item))).defaultMapColor().col;
        }

        @Override
        public IGuiTexture getItemIcon(String item) {
            return this.ICON_CACHE.computeIfAbsent(item, name -> {
                Material mat;
                if (name.startsWith("material_") && !(mat = GTMaterials.get(name.substring(9))).isNull()) {
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    for (TagPrefix oreTag : TagPrefix.ORES.keySet()) {
                        for (Block block : ChemicalHelper.getBlocks(new MaterialEntry(oreTag, mat))) {
                            list.add(new ItemStack((ItemLike)block));
                        }
                    }
                    return new ItemStackTexture((ItemStack[])list.toArray(ItemStack[]::new)).scale(0.8f);
                }
                return new ItemStackTexture(new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.BLOCK.get(new ResourceLocation(name)))}).scale(0.8f);
            });
        }

        @Override
        public String getDescriptionId(String item) {
            Material mat;
            if (item.startsWith("material_") && !(mat = GTMaterials.get(item.substring(9))).isNull()) {
                return mat.getUnlocalizedName();
            }
            return ((Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(item))).getDescriptionId();
        }

        @Override
        public String getUniqueID(String item) {
            return item;
        }

        @Override
        public void serialize(String item, FriendlyByteBuf buf) {
            buf.writeUtf(item);
        }

        @Override
        public String deserialize(FriendlyByteBuf buf) {
            return buf.readUtf();
        }

        @Override
        public Class<String> getItemClass() {
            return String.class;
        }

        @Override
        public void appendTooltips(List<String[]> items, List<Component> tooltips, String selected) {
            Object2IntOpenHashMap counter = new Object2IntOpenHashMap();
            for (String[] array : items) {
                for (String item2 : array) {
                    if (!"[all]".equals(selected) && !selected.equals(this.getUniqueID(item2))) continue;
                    counter.addTo((Object)item2, 1);
                }
            }
            counter.forEach((item, count) -> tooltips.add((Component)Component.translatable((String)this.getDescriptionId((String)item)).append(" --- " + count)));
        }
    };
    public static ProspectorMode<FluidInfo> FLUID = new ProspectorMode<FluidInfo>("metaitem.prospector.mode.fluid", 1){

        public void scan(FluidInfo[][][] storage, LevelChunk chunk) {
            ServerLevel serverLevel;
            FluidVeinWorldEntry fluidVein;
            Level level = chunk.getLevel();
            if (level instanceof ServerLevel && (fluidVein = BedrockFluidVeinSavedData.getOrCreate(serverLevel = (ServerLevel)level).getFluidVeinWorldEntry(chunk.getPos().x, chunk.getPos().z)).getDefinition() != null) {
                storage[0][0] = new FluidInfo[]{FluidInfo.fromVeinWorldEntry(fluidVein)};
            }
        }

        @Override
        public int getItemColor(FluidInfo item) {
            net.minecraftforge.fluids.FluidStack fluidStack = new net.minecraftforge.fluids.FluidStack(item.fluid, item.yield);
            if (fluidStack.getFluid() == Fluids.LAVA) {
                return -36864;
            }
            return GTUtil.getFluidColor(fluidStack);
        }

        @Override
        public IGuiTexture getItemIcon(FluidInfo item) {
            return new ItemStackTexture(new Item[]{item.fluid.getBucket()});
        }

        @Override
        public String getDescriptionId(FluidInfo item) {
            return new net.minecraftforge.fluids.FluidStack(item.fluid, item.yield).getDisplayName().getString();
        }

        @Override
        public String getUniqueID(FluidInfo item) {
            return BuiltInRegistries.FLUID.getKey((Object)item.fluid).toString();
        }

        @Override
        public void serialize(FluidInfo item, FriendlyByteBuf buf) {
            buf.writeUtf(BuiltInRegistries.FLUID.getKey((Object)item.fluid).toString());
            buf.writeVarInt(item.yield);
            buf.writeVarInt(item.left);
        }

        @Override
        public FluidInfo deserialize(FriendlyByteBuf buf) {
            return new FluidInfo((Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(buf.readUtf())), buf.readVarInt(), buf.readVarInt());
        }

        @Override
        public Class<FluidInfo> getItemClass() {
            return FluidInfo.class;
        }

        @Override
        public void appendTooltips(List<FluidInfo[]> items, List<Component> tooltips, String selected) {
            for (FluidInfo[] array : items) {
                for (FluidInfo item : array) {
                    tooltips.add((Component)Component.translatable((String)this.getDescriptionId(item)).append(" --- %s (%s%%)".formatted(item.yield, item.left)));
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void drawSpecialGrid(GuiGraphics graphics, FluidInfo[] items, int x, int y, int width, int height) {
            if (items.length > 0) {
                FluidInfo item = items[0];
                double progress = (double)item.left * 1.0 / (double)Math.max(Math.min(item.left, 100), 1);
                float drawnU = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnU(progress);
                float drawnV = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnV(progress);
                float drawnWidth = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnWidth(progress);
                float drawnHeight = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnHeight(progress);
                DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (FluidStack)FluidHelperImpl.toFluidStack((net.minecraftforge.fluids.FluidStack)new net.minecraftforge.fluids.FluidStack(item.fluid(), item.left)), (long)100L, (int)((int)((float)x + drawnU * (float)width)), (int)((int)((float)y + drawnV * (float)height)), (int)((int)((float)width * drawnWidth)), (int)((int)((float)height * drawnHeight)));
            }
        }
    };
    public static ProspectorMode<OreInfo> BEDROCK_ORE = new ProspectorMode<OreInfo>("metaitem.prospector.mode.bedrock_ore", 1){

        public void scan(OreInfo[][][] storage, LevelChunk chunk) {
            ServerLevel serverLevel;
            OreVeinWorldEntry oreVein;
            Level level = chunk.getLevel();
            if (level instanceof ServerLevel && (oreVein = BedrockOreVeinSavedData.getOrCreate(serverLevel = (ServerLevel)level).getOreVeinWorldEntry(chunk.getPos().x, chunk.getPos().z)).getDefinition() != null) {
                int left = 100 * oreVein.getOperationsRemaining() / 100000;
                for (WeightedMaterial entry : oreVein.getDefinition().materials()) {
                    storage[0][0] = (OreInfo[])ArrayUtils.add((Object[])storage[0][0], (Object)new OreInfo(entry.material(), entry.weight(), left, oreVein.getOreYield()));
                }
            }
        }

        @Override
        public int getItemColor(OreInfo item) {
            return item.material.getMaterialRGB();
        }

        @Override
        public IGuiTexture getItemIcon(OreInfo item) {
            Material material = item.material;
            ItemStack stack = ChemicalHelper.get(TagPrefix.get(ConfigHolder.INSTANCE.machines.bedrockOreDropTagPrefix), material);
            if (stack.isEmpty()) {
                stack = ChemicalHelper.get(TagPrefix.crushed, material);
            }
            if (stack.isEmpty()) {
                stack = ChemicalHelper.get(TagPrefix.gem, material);
            }
            if (stack.isEmpty()) {
                stack = ChemicalHelper.get(TagPrefix.ore, material);
            }
            if (stack.isEmpty()) {
                stack = ChemicalHelper.get(TagPrefix.dust, material);
            }
            return new ItemStackTexture(new ItemStack[]{stack}).scale(0.8f);
        }

        @Override
        public String getDescriptionId(OreInfo item) {
            return item.material.getUnlocalizedName();
        }

        @Override
        public String getUniqueID(OreInfo item) {
            return item.material.getName();
        }

        @Override
        public void serialize(OreInfo item, FriendlyByteBuf buf) {
            buf.writeResourceLocation(item.material.getResourceLocation());
            buf.writeVarInt(item.weight);
            buf.writeVarInt(item.left);
            buf.writeVarInt(item.yield);
        }

        @Override
        public OreInfo deserialize(FriendlyByteBuf buf) {
            ResourceLocation materialId = buf.readResourceLocation();
            return new OreInfo((Material)GTCEuAPI.materialManager.getRegistry(materialId.getNamespace()).get(materialId.getPath()), buf.readVarInt(), buf.readVarInt(), buf.readVarInt());
        }

        @Override
        public Class<OreInfo> getItemClass() {
            return OreInfo.class;
        }

        @Override
        public void appendTooltips(List<OreInfo[]> items, List<Component> tooltips, String selected) {
            for (OreInfo[] array : items) {
                int totalWeight = Arrays.stream(array).mapToInt(OreInfo::weight).sum();
                for (OreInfo item : array) {
                    float chance = (float)item.weight / (float)totalWeight * 100.0f;
                    tooltips.add((Component)Component.translatable((String)this.getDescriptionId(item)).append(" (").append((Component)Component.translatable((String)"gtceu.gui.content.chance_base", (Object[])new Object[]{FormattingUtil.formatNumber2Places(chance)})).append(") --- %s (%s%%)".formatted(item.yield, item.left)));
                }
            }
        }
    };
    public final String unlocalizedName;
    public final int cellSize;

    ProspectorMode(@NotNull String unlocalizedName, int cellSize) {
        this.unlocalizedName = unlocalizedName;
        this.cellSize = cellSize;
    }

    public abstract void scan(T[][][] var1, LevelChunk var2);

    public abstract int getItemColor(T var1);

    public abstract IGuiTexture getItemIcon(T var1);

    public abstract String getDescriptionId(T var1);

    public abstract String getUniqueID(T var1);

    public abstract void serialize(T var1, FriendlyByteBuf var2);

    public abstract T deserialize(FriendlyByteBuf var1);

    public abstract Class<T> getItemClass();

    public abstract void appendTooltips(List<T[]> var1, List<Component> var2, String var3);

    @OnlyIn(value=Dist.CLIENT)
    public void drawSpecialGrid(GuiGraphics graphics, T[] items, int x, int y, int width, int height) {
    }

    public record OreInfo(Material material, int weight, int left, int yield) {
    }

    public static final class FluidInfo {
        private final Fluid fluid;
        private final int yield;
        private int left;

        public static FluidInfo fromNbt(CompoundTag tag) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(tag.getString("fluid")));
            int left = tag.getInt("left");
            int yield = tag.getInt("yield");
            return new FluidInfo(fluid, yield, left);
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.putString("fluid", BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
            tag.putInt("left", this.left);
            tag.putInt("yield", this.yield);
            return tag;
        }

        public static FluidInfo fromVeinWorldEntry(@NotNull FluidVeinWorldEntry savedData) {
            if (savedData.getDefinition() == null) {
                return null;
            }
            return new FluidInfo(savedData.getDefinition().getStoredFluid().get(), savedData.getFluidYield(), 100 * savedData.getOperationsRemaining() / 100000);
        }

        @Generated
        public FluidInfo(Fluid fluid, int yield, int left) {
            this.fluid = fluid;
            this.yield = yield;
            this.left = left;
        }

        @Generated
        public Fluid fluid() {
            return this.fluid;
        }

        @Generated
        public int yield() {
            return this.yield;
        }

        @Generated
        public int left() {
            return this.left;
        }

        @NotNull
        @Generated
        public FluidInfo left(int left) {
            this.left = left;
            return this;
        }
    }
}

