/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import lombok.Generated;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class GhostCircuitSlotWidget
extends SlotWidget {
    private static final int SET_TO_ZERO = 1;
    private static final int SET_TO_EMPTY = 2;
    private static final int SET_TO_N = 3;
    private static final int NO_CONFIG = -1;
    private IItemHandlerModifiable circuitInventory;
    @Nullable
    private Widget configurator;

    public void setCircuitInventory(IItemHandlerModifiable circuitInventory) {
        this.circuitInventory = circuitInventory;
        this.setHandlerSlot(circuitInventory, 0);
    }

    public boolean isConfiguratorOpen() {
        return this.configurator != null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (button == 0 && Screen.hasShiftDown()) {
                if (!this.isConfiguratorOpen()) {
                    this.configurator = this.createConfigurator();
                    this.gui.widget(this.configurator);
                } else {
                    this.gui.mainGroup.removeWidget(this.configurator);
                    this.configurator = null;
                }
            } else if (button == 0) {
                int newValue = this.getNextValue(true);
                this.setCircuitValue(newValue);
            } else if (button == 1 && Screen.hasShiftDown()) {
                this.circuitInventory.setStackInSlot(0, ItemStack.EMPTY);
                this.writeClientAction(2, buf -> {});
            } else if (button == 1) {
                int newValue = this.getNextValue(false);
                this.setCircuitValue(newValue);
            }
            return true;
        }
        return false;
    }

    private int getNextValue(boolean increment) {
        int currentValue = IntCircuitBehaviour.getCircuitConfiguration(this.circuitInventory.getStackInSlot(0));
        if (increment) {
            if (currentValue == 32) {
                return 0;
            }
            if (this.circuitInventory.getStackInSlot(0).isEmpty()) {
                return 1;
            }
            return currentValue + 1;
        }
        if (this.circuitInventory.getStackInSlot(0).isEmpty()) {
            return 32;
        }
        if (currentValue == 1) {
            return -1;
        }
        return currentValue - 1;
    }

    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.isConfiguratorOpen()) {
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            int newValue = this.getNextValue(wheelDelta >= 0.0);
            this.setCircuitValue(newValue);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    public void setCircuitValue(int newValue) {
        if (newValue == -1) {
            this.circuitInventory.setStackInSlot(0, ItemStack.EMPTY);
            this.writeClientAction(2, buf -> {});
        } else {
            this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack(newValue));
            this.writeClientAction(3, buf -> buf.writeVarInt(newValue));
        }
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        switch (id) {
            case 1: {
                this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack(0));
                break;
            }
            case 2: {
                this.circuitInventory.setStackInSlot(0, ItemStack.EMPTY);
                break;
            }
            case 3: {
                this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack(buffer.readVarInt()));
            }
        }
    }

    public Widget createConfigurator() {
        int x;
        WidgetGroup group = new WidgetGroup(0, 0, 174, 132);
        group.addWidget((Widget)new LabelWidget(9, 8, "Programmed Circuit Configuration"));
        group.addWidget(new SlotWidget(this.circuitInventory, 0, (group.getSize().width - 18) / 2, 20, !ConfigHolder.INSTANCE.machines.ghostCircuit, !ConfigHolder.INSTANCE.machines.ghostCircuit).setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.INT_CIRCUIT_OVERLAY})}));
        if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
            group.addWidget((Widget)new ButtonWidget((group.getSize().width - 18) / 2, 20, 18, 18, IGuiTexture.EMPTY, clickData -> {
                if (!clickData.isRemote) {
                    this.circuitInventory.setStackInSlot(0, ItemStack.EMPTY);
                }
            }));
        }
        int idx = 0;
        for (x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 8; ++y) {
                int finalIdx = idx++;
                group.addWidget((Widget)new ButtonWidget(5 + 18 * y, 48 + 18 * x, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(finalIdx)}).scale(0.8888889f)}), clickData -> {
                    if (!clickData.isRemote) {
                        ItemStack stack = this.circuitInventory.getStackInSlot(0).copy();
                        if (IntCircuitBehaviour.isIntegratedCircuit(stack)) {
                            IntCircuitBehaviour.setCircuitConfiguration(stack, finalIdx);
                            this.circuitInventory.setStackInSlot(0, stack);
                        } else if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
                            this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack(finalIdx));
                        }
                    }
                }));
            }
        }
        for (x = 0; x <= 5; ++x) {
            int finalIdx = x + 27;
            group.addWidget((Widget)new ButtonWidget(5 + 18 * x, 102, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(finalIdx)}).scale(0.8888889f)}), clickData -> {
                if (!clickData.isRemote) {
                    ItemStack stack = this.circuitInventory.getStackInSlot(0).copy();
                    if (IntCircuitBehaviour.isIntegratedCircuit(stack)) {
                        IntCircuitBehaviour.setCircuitConfiguration(stack, finalIdx);
                        this.circuitInventory.setStackInSlot(0, stack);
                    } else if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
                        this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack(finalIdx));
                    }
                }
            }));
        }
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND});
        return group;
    }

    @Generated
    public IItemHandlerModifiable getCircuitInventory() {
        return this.circuitInventory;
    }
}

