/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternPreviewSlotWidget
extends SlotWidget {
    public PatternPreviewSlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(itemHandler, slotIndex, xPosition, yPosition, canTakeItems, canPutItems);
    }

    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundTexture(graphics, mouseX, mouseY);
        Position pos = this.getPosition();
        if (this.slotReference != null) {
            ModularUIGuiContainer modularUIGui;
            ItemStack itemStack = this.getRealStack(this.slotReference.getItem());
            ModularUIGuiContainer modularUIGuiContainer = modularUIGui = this.gui == null ? null : this.gui.getModularUIGui();
            if (itemStack.isEmpty() && modularUIGui != null && modularUIGui.getQuickCrafting() && modularUIGui.getQuickCraftSlots().contains(this.slotReference)) {
                int splitSize = modularUIGui.getQuickCraftSlots().size();
                itemStack = this.gui.getModularUIContainer().getCarried();
                if (!itemStack.isEmpty() && splitSize > 1 && AbstractContainerMenu.canItemQuickReplace((Slot)this.slotReference, (ItemStack)itemStack, (boolean)true)) {
                    itemStack = itemStack.copy();
                    itemStack.grow(AbstractContainerMenu.getQuickCraftPlaceCount((Set)modularUIGui.getQuickCraftSlots(), (int)modularUIGui.dragSplittingLimit, (ItemStack)itemStack));
                    int k = Math.min(itemStack.getMaxStackSize(), this.slotReference.getMaxStackSize(itemStack));
                    if (itemStack.getCount() > k) {
                        itemStack.setCount(k);
                    }
                }
            }
            if (!itemStack.isEmpty()) {
                PatternPreviewSlotWidget.drawItemStack(graphics, itemStack, pos.x + 1, pos.y + 1, -1, null);
            }
        }
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        if (this.drawHoverOverlay && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(this.getPosition().x + 1), (int)(this.getPosition().y + 1), (int)16, (int)16, (int)-2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    public static void drawItemStack(@Nonnull GuiGraphics graphics, ItemStack itemStack, int x, int y, int color, @Nullable String altTxt) {
        float a = ColorUtils.alpha((int)color);
        float r = ColorUtils.red((int)color);
        float g = ColorUtils.green((int)color);
        float b = ColorUtils.blue((int)color);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        Minecraft mc = Minecraft.getInstance();
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        graphics.renderItem(itemStack, x, y);
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        graphics.pose().pushPose();
        int xOffset = 0;
        if (itemStack.getCount() / 100000 != 0) {
            xOffset = 9;
        } else if (itemStack.getCount() / 10000 != 0) {
            xOffset = 6;
        } else if (itemStack.getCount() / 1000 != 0) {
            xOffset = 3;
        }
        graphics.renderItemDecorations(mc.font, itemStack, x + xOffset, y, altTxt);
        graphics.pose().popPose();
        graphics.pose().popPose();
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
    }
}

