/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PatternPreviewSlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.ItemStackKey;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.screen.RecipeScreen;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class PatternPreviewWidget
extends WidgetGroup {
    private boolean isLoaded;
    private static TrackedDummyWorld LEVEL;
    private static final int REGION_SIZE = 512;
    private static int LAST_OFFSET_INDEX;
    private static final Map<MultiblockMachineDefinition, MBPattern[]> CACHE;
    private final SceneWidget sceneWidget;
    private final DraggableScrollableWidgetGroup scrollableWidgetGroup;
    public final MultiblockMachineDefinition controllerDefinition;
    public final MBPattern[] patterns;
    private final List<SimplePredicate> predicates;
    private int index;
    public int layer;
    private SlotWidget[] slotWidgets;
    private SlotWidget[] candidates;

    protected PatternPreviewWidget(MultiblockMachineDefinition controllerDefinition) {
        super(0, 0, 160, 160);
        this.setClientSideWidget();
        this.controllerDefinition = controllerDefinition;
        this.predicates = new ArrayList<SimplePredicate>();
        this.layer = -1;
        this.sceneWidget = new SceneWidget(3, 3, 150, 150, (Level)LEVEL){

            public void renderBlockOverLay(WorldSceneRenderer renderer) {
                BlockPosFace tmp;
                BlockHitResult hit;
                PoseStack poseStack = new PoseStack();
                this.hoverPosFace = null;
                this.hoverItem = null;
                if (this.isMouseOverElement(this.currentMouseX, this.currentMouseY) && (hit = renderer.getLastTraceResult()) != null) {
                    if (this.core.contains(hit.getBlockPos())) {
                        this.hoverPosFace = new BlockPosFace(hit.getBlockPos(), hit.getDirection());
                    } else if (!this.useOrtho) {
                        Vector3f hitPos = hit.getLocation().toVector3f();
                        Level world = renderer.world;
                        Vec3 eyePos = new Vec3(renderer.getEyePos());
                        hitPos.mul(2.0f);
                        Vec3 endPos = new Vec3((double)hitPos.x - eyePos.x, (double)hitPos.y - eyePos.y, (double)hitPos.z - eyePos.z);
                        double min = 3.4028234663852886E38;
                        for (BlockPos pos : this.core) {
                            double dist;
                            BlockState blockState = world.getBlockState(pos);
                            if (blockState.getBlock() == Blocks.AIR || (hit = world.clipWithInteractionOverride(eyePos, endPos, pos, blockState.getShape((BlockGetter)world, pos), blockState)) == null || hit.getType() == HitResult.Type.MISS || !((dist = eyePos.distanceToSqr(hit.getLocation())) < min)) continue;
                            min = dist;
                            this.hoverPosFace = new BlockPosFace(hit.getBlockPos(), hit.getDirection());
                        }
                    }
                }
                if (this.hoverPosFace != null) {
                    BlockState state = this.getDummyWorld().getBlockState(this.hoverPosFace.pos);
                    this.hoverItem = state.getBlock().getCloneItemStack((BlockGetter)this.getDummyWorld(), this.hoverPosFace.pos, state);
                }
                BlockPosFace blockPosFace = tmp = this.dragging ? this.clickPosFace : this.hoverPosFace;
                if (this.selectedPosFace != null || tmp != null) {
                    if (this.selectedPosFace != null && this.renderFacing) {
                        this.drawFacingBorder(poseStack, this.selectedPosFace, -16711936);
                    }
                    if (tmp != null && !tmp.equals((Object)this.selectedPosFace) && this.renderFacing) {
                        this.drawFacingBorder(poseStack, tmp, -1);
                    }
                }
                if (this.selectedPosFace != null && this.renderSelect) {
                    RenderUtils.renderBlockOverLay((PoseStack)poseStack, (BlockPos)this.selectedPosFace.pos, (float)0.6f, (float)0.0f, (float)0.0f, (float)1.03f);
                }
                if (this.afterWorldRender != null) {
                    this.afterWorldRender.accept(this);
                }
            }
        }.setOnSelected(this::onPosSelected).setRenderFacing(false).setRenderFacing(false);
        this.addWidget((Widget)this.sceneWidget);
        this.scrollableWidgetGroup = new DraggableScrollableWidgetGroup(3, 132, 154, 22).setXScrollBarHeight(4).setXBarStyle((IGuiTexture)GuiTextures.SLIDER_BACKGROUND, (IGuiTexture)GuiTextures.BUTTON).setScrollable(true).setDraggable(true);
        this.scrollableWidgetGroup.setScrollWheelDirection(DraggableScrollableWidgetGroup.ScrollWheelDirection.HORIZONTAL);
        this.scrollableWidgetGroup.setScrollYOffset(0);
        this.addWidget((Widget)this.scrollableWidgetGroup);
        if (ConfigHolder.INSTANCE.client.useVBO) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> ((SceneWidget)this.sceneWidget).useCacheBuffer());
            } else {
                this.sceneWidget.useCacheBuffer();
            }
        }
        this.addWidget((Widget)new ImageWidget(3, 3, 160, 10, (IGuiTexture)new TextTexture(controllerDefinition.getDescriptionId(), -1).setType(TextTexture.TextType.ROLL).setWidth(170).setDropShadow(true)));
        this.patterns = CACHE.computeIfAbsent(controllerDefinition, definition -> {
            HashSet<ItemStackKey> drops = new HashSet<ItemStackKey>();
            drops.add(new ItemStackKey(new ItemStack[]{this.controllerDefinition.asStack()}));
            return (MBPattern[])controllerDefinition.getMatchingShapes().stream().map(it -> this.initializePattern((MultiblockShapeInfo)it, drops)).filter(Objects::nonNull).toArray(MBPattern[]::new);
        });
        this.addWidget((Widget)new ButtonWidget(138, 30, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture(), new TextTexture("1").setSupplier(() -> "P:" + this.index)}), x -> this.setPage(this.index + 1 >= this.patterns.length ? 0 : this.index + 1)).setHoverBorderTexture(1, -1));
        this.addWidget((Widget)new ButtonWidget(138, 50, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture(), new TextTexture("1").setSupplier(() -> this.layer >= 0 ? "L:" + this.layer : "ALL")}), cd -> this.updateLayer()).setHoverBorderTexture(1, -1));
        this.setPage(0);
    }

    private void updateLayer() {
        MBPattern pattern = this.patterns[this.index];
        if (this.layer + 1 >= -1 && this.layer + 1 <= pattern.maxY - pattern.minY) {
            ++this.layer;
            if (pattern.controllerBase.isFormed()) {
                this.onFormedSwitch(false);
            }
        } else {
            this.layer = -1;
            if (!pattern.controllerBase.isFormed()) {
                this.onFormedSwitch(true);
            }
        }
        this.setupScene(pattern);
    }

    private void setupScene(MBPattern pattern) {
        LongSet modelDisabled;
        Stream<BlockPos> stream = pattern.blockMap.keySet().stream().filter(pos -> this.layer == -1 || this.layer + pattern.minY == pos.getY());
        if (pattern.controllerBase.isFormed() && !(modelDisabled = (LongSet)pattern.controllerBase.getMultiblockState().getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET)).isEmpty()) {
            stream = stream.filter(pos -> !modelDisabled.contains(pos.asLong()));
        }
        this.sceneWidget.setRenderedCore(stream.toList(), null);
    }

    public static PatternPreviewWidget getPatternWidget(MultiblockMachineDefinition controllerDefinition) {
        if (LEVEL == null) {
            if (Minecraft.getInstance().level == null) {
                GTCEu.LOGGER.error("Try to init pattern previews before level load");
                throw new IllegalStateException();
            }
            LEVEL = new TrackedDummyWorld();
        }
        return new PatternPreviewWidget(controllerDefinition);
    }

    public void setPage(int index) {
        if (index >= this.patterns.length || index < 0) {
            return;
        }
        this.index = index;
        this.layer = -1;
        MBPattern pattern = this.patterns[index];
        this.setupScene(pattern);
        if (this.slotWidgets != null) {
            for (SlotWidget slotWidget : this.slotWidgets) {
                this.scrollableWidgetGroup.removeWidget((Widget)slotWidget);
            }
        }
        this.slotWidgets = new SlotWidget[Math.min(pattern.parts.size(), 18)];
        CycleItemStackHandler itemHandler = new CycleItemStackHandler(pattern.parts);
        int xOffset = 0;
        for (int i = 0; i < this.slotWidgets.length; ++i) {
            int padding = 1;
            if (itemHandler.getStackInSlot(i).getCount() / 100000 >= 1) {
                padding = 10;
            } else if (itemHandler.getStackInSlot(i).getCount() / 10000 >= 1) {
                padding = 7;
            } else if (itemHandler.getStackInSlot(i).getCount() / 1000 >= 1) {
                padding = 4;
            }
            this.slotWidgets[i] = new PatternPreviewSlotWidget(itemHandler, i, 4 + xOffset + padding, 0, false, false).setBackgroundTexture((IGuiTexture)ColorPattern.T_GRAY.rectTexture()).setIngredientIO(IngredientIO.INPUT);
            xOffset += 18 + 2 * padding;
            this.scrollableWidgetGroup.addWidget((Widget)this.slotWidgets[i]);
        }
    }

    private void onFormedSwitch(boolean isFormed) {
        MBPattern pattern = this.patterns[this.index];
        IMultiController controllerBase = pattern.controllerBase;
        if (isFormed) {
            this.layer = -1;
            this.loadControllerFormed(pattern.blockMap.keySet(), controllerBase);
        } else {
            this.sceneWidget.setRenderedCore(pattern.blockMap.keySet(), null);
            controllerBase.onStructureInvalid();
        }
    }

    private void onPosSelected(BlockPos pos, Direction facing) {
        if (this.index >= this.patterns.length || this.index < 0) {
            return;
        }
        TraceabilityPredicate predicate = this.patterns[this.index].predicateMap.get(pos);
        if (predicate != null) {
            this.predicates.clear();
            this.predicates.addAll(predicate.common);
            this.predicates.addAll(predicate.limited);
            this.predicates.removeIf(p -> p == null || p.candidates == null);
            if (this.candidates != null) {
                for (SlotWidget candidate : this.candidates) {
                    this.removeWidget((Widget)candidate);
                }
            }
            ArrayList<List<ItemStack>> candidateStacks = new ArrayList<List<ItemStack>>();
            ArrayList<List<Component>> predicateTips = new ArrayList<List<Component>>();
            for (SimplePredicate simplePredicate : this.predicates) {
                List<ItemStack> itemStacks = simplePredicate.getCandidates();
                if (itemStacks.isEmpty()) continue;
                candidateStacks.add(itemStacks);
                predicateTips.add(simplePredicate.getToolTips(predicate));
            }
            this.candidates = new SlotWidget[candidateStacks.size()];
            CycleItemStackHandler itemHandler = new CycleItemStackHandler(candidateStacks);
            int maxCol = (160 - ((this.slotWidgets.length - 1) / 9 + 1) * 18 - 35) % 18;
            for (int i = 0; i < candidateStacks.size(); ++i) {
                int finalI = i;
                this.candidates[i] = new SlotWidget(itemHandler, i, 3 + i / maxCol * 18, 3 + i % maxCol * 18, false, false).setIngredientIO(IngredientIO.INPUT).setBackgroundTexture((IGuiTexture)new ColorRectTexture(0x4FFFFFFF)).setOnAddedTooltips((slot, list) -> list.addAll((Collection)predicateTips.get(finalI)));
                this.addWidget((Widget)this.candidates[i]);
            }
        }
    }

    public static BlockPos locateNextRegion() {
        int currentIndex = LAST_OFFSET_INDEX++;
        int x = 0;
        int z = 0;
        if (currentIndex > 0) {
            int v = (int)(Mth.sqrt((float)((float)currentIndex + 0.25f)) - 0.5f);
            int nextV = v + 1;
            int spiralBaseIndex = v * nextV;
            int flipFlop = (v & 1) * 2 - 1;
            int offset = flipFlop * nextV / 2;
            x += offset;
            z += offset;
            int cornerIndex = spiralBaseIndex + nextV;
            if (currentIndex < cornerIndex) {
                x -= flipFlop * (currentIndex - spiralBaseIndex + 1);
            } else {
                x -= flipFlop * nextV;
                z -= flipFlop * (currentIndex - cornerIndex + 1);
            }
        }
        return new BlockPos(x * 512, 50, z * 512);
    }

    public void updateScreen() {
        super.updateScreen();
        if (!this.isLoaded && GTCEu.Mods.isEMILoaded() && Minecraft.getInstance().screen instanceof RecipeScreen) {
            this.setPage(0);
            this.isLoaded = true;
        } else if (!this.isLoaded && GTCEu.Mods.isREILoaded() && Minecraft.getInstance().screen instanceof AbstractDisplayViewingScreen) {
            this.setPage(0);
            this.isLoaded = true;
        }
    }

    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
    }

    private MBPattern initializePattern(MultiblockShapeInfo shapeInfo, HashSet<ItemStackKey> blockDrops) {
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        IMultiController controllerBase = null;
        BlockPos multiPos = PatternPreviewWidget.locateNextRegion();
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        for (int x = 0; x < blocks.length; ++x) {
            BlockInfo[][] aisle = blocks[x];
            for (int y = 0; y < aisle.length; ++y) {
                BlockInfo[] column = aisle[y];
                for (int z = 0; z < column.length; ++z) {
                    IMachineBlockEntity holder;
                    BlockState blockState = column[z].getBlockState();
                    BlockPos pos = multiPos.offset(x, y, z);
                    Object object = column[z].getBlockEntity(pos);
                    if (object instanceof IMachineBlockEntity && (object = (holder = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiController) {
                        IMultiController controller = (IMultiController)object;
                        holder.getSelf().setLevel((Level)LEVEL);
                        controllerBase = controller;
                    }
                    blockMap.put(pos, BlockInfo.fromBlockState((BlockState)blockState));
                }
            }
        }
        LEVEL.addBlocks(blockMap);
        if (controllerBase != null) {
            LEVEL.setInnerBlockEntity(controllerBase.self().holder.getSelf());
        }
        Map<ItemStackKey, PartInfo> parts = this.gatherBlockDrops(blockMap);
        blockDrops.addAll(parts.keySet());
        HashMap<BlockPos, TraceabilityPredicate> predicateMap = new HashMap();
        if (controllerBase != null) {
            this.loadControllerFormed(predicateMap.keySet(), controllerBase);
            predicateMap = (Map)controllerBase.getMultiblockState().getMatchContext().get("predicates");
        }
        return controllerBase == null ? null : new MBPattern(blockMap, parts.values().stream().sorted((one, two) -> {
            if (one.isController) {
                return -1;
            }
            if (two.isController) {
                return 1;
            }
            if (one.isTile && !two.isTile) {
                return -1;
            }
            if (two.isTile && !one.isTile) {
                return 1;
            }
            if (one.blockId != two.blockId) {
                return two.blockId - one.blockId;
            }
            return two.amount - one.amount;
        }).map(PartInfo::getItemStack).filter(list -> !list.isEmpty()).collect(Collectors.toList()), predicateMap, controllerBase);
    }

    private void loadControllerFormed(Collection<BlockPos> positions, IMultiController controllerBase) {
        BlockPattern pattern = controllerBase.getPattern();
        if (pattern != null && pattern.checkPatternAt(controllerBase.getMultiblockState(), true)) {
            controllerBase.onStructureFormed();
        }
        if (controllerBase.isFormed()) {
            LongSet modelDisabled = (LongSet)controllerBase.getMultiblockState().getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
            if (!modelDisabled.isEmpty()) {
                positions = new HashSet<BlockPos>(positions);
                positions.removeIf(pos -> modelDisabled.contains(pos.asLong()));
            }
            this.sceneWidget.setRenderedCore(positions, null);
        } else {
            GTCEu.LOGGER.warn("Pattern formed checking failed: {}", (Object)controllerBase.self().getDefinition());
        }
    }

    private Map<ItemStackKey, PartInfo> gatherBlockDrops(Map<BlockPos, BlockInfo> blocks) {
        Object2ObjectOpenHashMap partsMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<BlockPos, BlockInfo> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState blockState = LEVEL.getBlockState(pos);
            ItemStack itemStack = blockState.getBlock().getCloneItemStack((BlockGetter)LEVEL, pos, blockState);
            if (itemStack.isEmpty() && !blockState.getFluidState().isEmpty()) {
                Fluid fluid = blockState.getFluidState().getType();
                itemStack = fluid.getBucket().getDefaultInstance();
            }
            ItemStackKey itemStackKey = new ItemStackKey(new ItemStack[]{itemStack});
            ++partsMap.computeIfAbsent(itemStackKey, (Function<ItemStackKey, PartInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$gatherBlockDrops$14(java.util.Map$Entry com.lowdragmc.lowdraglib.utils.ItemStackKey ), (Lcom/lowdragmc/lowdraglib/utils/ItemStackKey;)Lcom/gregtechceu/gtceu/api/gui/widget/PatternPreviewWidget$PartInfo;)(entry)).amount;
        }
        return partsMap;
    }

    private static /* synthetic */ PartInfo lambda$gatherBlockDrops$14(Map.Entry entry, ItemStackKey key) {
        return new PartInfo(key, (BlockInfo)entry.getValue());
    }

    static {
        LAST_OFFSET_INDEX = 0;
        CACHE = new HashMap<MultiblockMachineDefinition, MBPattern[]>();
    }

    public static class MBPattern {
        @NotNull
        final List<List<ItemStack>> parts;
        @NotNull
        final Map<BlockPos, TraceabilityPredicate> predicateMap;
        @NotNull
        final Map<BlockPos, BlockInfo> blockMap;
        @NotNull
        final IMultiController controllerBase;
        final int maxY;
        final int minY;

        public MBPattern(@NotNull Map<BlockPos, BlockInfo> blockMap, @NotNull List<List<ItemStack>> parts, @NotNull Map<BlockPos, TraceabilityPredicate> predicateMap, @NotNull IMultiController controllerBase) {
            this.parts = parts;
            this.blockMap = blockMap;
            this.predicateMap = predicateMap;
            this.controllerBase = controllerBase;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (BlockPos pos : blockMap.keySet()) {
                min = Math.min(min, pos.getY());
                max = Math.max(max, pos.getY());
            }
            this.minY = min;
            this.maxY = max;
        }
    }

    private static class PartInfo {
        final ItemStackKey itemStackKey;
        boolean isController = false;
        boolean isTile = false;
        final int blockId;
        int amount = 0;

        PartInfo(ItemStackKey itemStackKey, BlockInfo blockInfo) {
            this.itemStackKey = itemStackKey;
            this.blockId = Block.getId((BlockState)blockInfo.getBlockState());
            this.isTile = blockInfo.hasBlockEntity();
            Block block = blockInfo.getBlockState().getBlock();
            if (block instanceof MetaMachineBlock) {
                MetaMachineBlock block2 = (MetaMachineBlock)block;
                if (block2.definition instanceof MultiblockMachineDefinition) {
                    this.isController = true;
                }
            }
        }

        public List<ItemStack> getItemStack() {
            return Arrays.stream(this.itemStackKey.getItemStack()).map(stack -> stack.copyWithCount(this.amount)).filter(item -> !item.isEmpty()).toList();
        }
    }
}

