/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.List;
import java.util.function.BooleanSupplier;

public class ToggleButtonWidget
extends SwitchWidget {
    private final IGuiTexture texture;
    private String tooltipText;
    private boolean isMultiLang;

    public ToggleButtonWidget(int xPosition, int yPosition, int width, int height, BooleanSupplier isPressedCondition, BooleanConsumer setPressedExecutor) {
        this(xPosition, yPosition, width, height, (IGuiTexture)GuiTextures.VANILLA_BUTTON, isPressedCondition, setPressedExecutor);
    }

    public ToggleButtonWidget(int xPosition, int yPosition, int width, int height, IGuiTexture buttonTexture, BooleanSupplier isPressedCondition, BooleanConsumer setPressedExecutor) {
        super(xPosition, yPosition, width, height, null);
        this.texture = buttonTexture;
        if (buttonTexture instanceof ResourceTexture) {
            ResourceTexture resourceTexture = (ResourceTexture)buttonTexture;
            this.setTexture((IGuiTexture)resourceTexture.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)resourceTexture.getSubTexture(0.0, 0.5, 1.0, 0.5));
        } else {
            this.setTexture(buttonTexture, buttonTexture);
        }
        this.setSupplier(isPressedCondition::getAsBoolean);
        this.setOnPressCallback((cd, bool) -> {
            setPressedExecutor.accept(bool.booleanValue());
            this.updateHoverTooltips();
        });
    }

    public ToggleButtonWidget setShouldUseBaseBackground() {
        if (this.texture != null) {
            this.setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.TOGGLE_BUTTON_BACK.getSubTexture(0.0, 0.0, 1.0, 0.5), this.texture}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.TOGGLE_BUTTON_BACK.getSubTexture(0.0, 0.5, 1.0, 0.5), this.texture}));
        }
        return this;
    }

    public ToggleButtonWidget setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
        this.updateHoverTooltips();
        return this;
    }

    public ToggleButtonWidget isMultiLang() {
        this.isMultiLang = true;
        this.updateHoverTooltips();
        return this;
    }

    protected void updateHoverTooltips() {
        if (this.tooltipText != null) {
            if (!this.isMultiLang) {
                this.setHoverTooltips(new String[]{this.tooltipText + (this.isPressed ? ".enabled" : ".disabled")});
            } else {
                this.setHoverTooltips(List.copyOf(LangHandler.getMultiLang(this.tooltipText + (this.isPressed ? ".enabled" : ".disabled"))));
            }
        }
    }
}

