/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.api.item.armor.IArmorLogic;
import com.gregtechceu.gtceu.api.item.component.ElectricStats;
import com.gregtechceu.gtceu.api.item.component.IItemHUDProvider;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArmorLogicSuite
implements IArmorLogic,
IItemHUDProvider {
    protected final int energyPerUse;
    protected final int tier;
    protected final long maxCapacity;
    protected final ArmorItem.Type type;

    protected ArmorLogicSuite(int energyPerUse, long maxCapacity, int tier, ArmorItem.Type type) {
        this.energyPerUse = energyPerUse;
        this.maxCapacity = maxCapacity;
        this.tier = tier;
        this.type = type;
    }

    @Override
    public abstract void onArmorTick(Level var1, Player var2, ItemStack var3);

    @Override
    public int getArmorDisplay(Player player, @NotNull ItemStack armor, EquipmentSlot slot) {
        IElectricItem item = GTCapabilityHelper.getElectricItem(armor);
        if (item == null) {
            return 0;
        }
        if (item.getCharge() >= (long)this.energyPerUse) {
            return (int)Math.round((double)(20.0f * this.getAbsorption()) * this.getDamageAbsorption());
        }
        return (int)Math.round((double)(4.0f * this.getAbsorption()) * this.getDamageAbsorption());
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != this.type.getSlot()) {
            return ImmutableMultimap.of();
        }
        IElectricItem item = GTCapabilityHelper.getElectricItem(stack);
        UUID uuid = IArmorLogic.ARMOR_MODIFIER_UUID_PER_TYPE.get(this.type);
        if (item == null) {
            return ImmutableMultimap.of();
        }
        if (item.getCharge() >= (long)this.energyPerUse) {
            return ImmutableMultimap.of((Object)Attributes.ARMOR, (Object)new AttributeModifier(uuid, "Armor modifier", (double)(20.0f * this.getAbsorption()) * this.getDamageAbsorption(), AttributeModifier.Operation.ADDITION));
        }
        return ImmutableMultimap.of((Object)Attributes.ARMOR, (Object)new AttributeModifier(uuid, "Armor modifier", (double)(4.0f * this.getAbsorption()) * this.getDamageAbsorption(), AttributeModifier.Operation.ADDITION));
    }

    @Override
    public void addToolComponents(ArmorComponentItem mvi) {
        mvi.attachComponents(new ElectricStats(this.maxCapacity, this.tier, true, false){

            @Override
            public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
                return ArmorLogicSuite.this.onRightClick(level, player, usedHand);
            }

            @Override
            public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
                ArmorLogicSuite.this.addInfo(stack, tooltipComponents);
            }
        });
    }

    public void addInfo(ItemStack itemStack, List<Component> lines) {
        IElectricItem cont = GTCapabilityHelper.getElectricItem(itemStack);
        if (cont != null) {
            ElectricStats.addCurrentChargeTooltip(lines, cont.getCharge(), cont.getMaxCharge(), cont.getTier(), false);
        }
    }

    public InteractionResultHolder<ItemStack> onRightClick(Level Level2, Player player, InteractionHand hand) {
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    @Override
    public ArmorItem.Type getArmorType() {
        return this.type;
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return null;
    }

    public double getDamageAbsorption() {
        return 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void addCapacityHUD(ItemStack stack, ArmorUtils.ModularHUD hud) {
        IElectricItem cont = GTCapabilityHelper.getElectricItem(stack);
        if (cont == null) {
            return;
        }
        if (cont.getCharge() == 0L) {
            return;
        }
        float energyMultiplier = (float)cont.getCharge() * 100.0f / (float)cont.getMaxCharge();
        hud.newString((Component)Component.translatable((String)"metaarmor.hud.energy_lvl", (Object[])new Object[]{String.format("%.1f", Float.valueOf(energyMultiplier)) + "%"}));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDrawHUD() {
        return this.type == ArmorItem.Type.CHESTPLATE;
    }

    public int getEnergyPerUse() {
        return this.energyPerUse;
    }

    protected float getAbsorption() {
        return switch (this.getArmorType()) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET, ArmorItem.Type.BOOTS -> 0.15f;
            case ArmorItem.Type.CHESTPLATE -> 0.4f;
            case ArmorItem.Type.LEGGINGS -> 0.3f;
        };
    }
}

