/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.DummyMachineBlockEntity;
import com.gregtechceu.gtceu.utils.InfiniteEnergyContainer;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import it.unimi.dsi.fastutil.chars.Char2ReferenceMap;
import it.unimi.dsi.fastutil.chars.Char2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.chars.CharSets;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ToolHelper {
    public static final String TOOL_TAG_KEY = "GT.Tool";
    public static final String BEHAVIOURS_TAG_KEY = "GT.Behaviours";
    public static final String MAX_CHARGE_KEY = "MaxCharge";
    public static final String CHARGE_KEY = "Charge";
    public static final String UNBREAKABLE_KEY = "Unbreakable";
    public static final String HIDE_FLAGS = "HideFlags";
    public static final String DISALLOW_CONTAINER_ITEM_KEY = "DisallowContainerItem";
    public static final String TINT_COLOR_KEY = "TintColor";
    public static final String DURABILITY_KEY = "Damage";
    public static final String MAX_DURABILITY_KEY = "MaxDamage";
    public static final String TOOL_SPEED_KEY = "ToolSpeed";
    public static final String ATTACK_DAMAGE_KEY = "AttackDamage";
    public static final String ATTACK_SPEED_KEY = "AttackSpeed";
    public static final String ENCHANTABILITY_KEY = "Enchantability";
    public static final String HARVEST_LEVEL_KEY = "HarvestLevel";
    public static final String DEFAULT_ENCHANTMENTS_KEY = "DefaultEnchantments";
    public static final String LAST_CRAFTING_USE_KEY = "LastCraftingUse";
    public static final String MAX_AOE_COLUMN_KEY = "MaxAoEColumn";
    public static final String MAX_AOE_ROW_KEY = "MaxAoERow";
    public static final String MAX_AOE_LAYER_KEY = "MaxAoELayer";
    public static final String AOE_COLUMN_KEY = "AoEColumn";
    public static final String AOE_ROW_KEY = "AoERow";
    public static final String AOE_LAYER_KEY = "AoELayer";
    public static final String HARVEST_ICE_KEY = "HarvestIce";
    public static final String TORCH_PLACING_KEY = "TorchPlacing";
    public static final String TORCH_PLACING_CACHE_SLOT_KEY = "TorchPlacing$Slot";
    public static final String TREE_FELLING_KEY = "TreeFelling";
    public static final String DISABLE_TREE_FELLING_KEY = "DisableTreeFelling";
    public static final String DISABLE_SHIELDS_KEY = "DisableShields";
    public static final String RELOCATE_MINED_BLOCKS_KEY = "RelocateMinedBlocks";
    public static final String RELOCATE_MOB_DROPS_KEY = "RelocateMobDrops";
    private static final Char2ReferenceMap<GTToolType> symbols = new Char2ReferenceOpenHashMap();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_LV = () -> ((ComponentItem)GTItems.POWER_UNIT_LV.get()).getDefaultInstance();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_MV = () -> ((ComponentItem)GTItems.POWER_UNIT_MV.get()).getDefaultInstance();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_HV = () -> ((ComponentItem)GTItems.POWER_UNIT_HV.get()).getDefaultInstance();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_EV = () -> ((ComponentItem)GTItems.POWER_UNIT_EV.get()).getDefaultInstance();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_IV = () -> ((ComponentItem)GTItems.POWER_UNIT_IV.get()).getDefaultInstance();

    private ToolHelper() {
    }

    public static GTToolType getToolFromSymbol(char symbol) {
        return (GTToolType)symbols.get(symbol);
    }

    public static @UnmodifiableView CharSet getToolSymbols() {
        return CharSets.unmodifiable((CharSet)symbols.keySet());
    }

    public static void registerToolSymbol(char symbol, GTToolType tool) {
        symbols.put(symbol, (Object)tool);
    }

    public static CompoundTag getToolTag(ItemStack stack) {
        return stack.getOrCreateTagElement(TOOL_TAG_KEY);
    }

    public static CompoundTag getBehaviorsTag(ItemStack stack) {
        return stack.getOrCreateTagElement(BEHAVIOURS_TAG_KEY);
    }

    public static boolean hasBehaviorsTag(ItemStack stack) {
        return stack.getTagElement(BEHAVIOURS_TAG_KEY) != null;
    }

    public static ItemStack get(GTToolType toolType, Material material) {
        ItemProviderEntry entry;
        if (material.hasProperty(PropertyKey.TOOL) && (entry = (ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)material, (Object)toolType)) != null) {
            return ((IGTTool)entry.get()).get();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getArmor(ArmorItem.Type armorType, Material material) {
        ItemEntry entry;
        if (material.hasProperty(PropertyKey.ARMOR) && (entry = (ItemEntry)GTMaterialItems.ARMOR_ITEMS.get((Object)material, (Object)armorType)) != null) {
            return ((ArmorItem)entry.get()).getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    public static boolean is(ItemStack stack, GTToolType toolType) {
        return ToolHelper.getToolTypes(stack).contains(toolType);
    }

    public static boolean canUse(ItemStack stack) {
        return stack.getDamageValue() <= stack.getMaxDamage();
    }

    public static void damageItem(@NotNull ItemStack stack, @Nullable LivingEntity user, int damage) {
        Item item = stack.getItem();
        if (!(item instanceof IGTTool)) {
            if (user != null) {
                stack.hurtAndBreak(damage, user, p -> {});
            }
        } else {
            Player player;
            IGTTool tool = (IGTTool)item;
            if (stack.getTag() != null && stack.getTag().getBoolean(UNBREAKABLE_KEY)) {
                return;
            }
            if (!(user instanceof Player) || !(player = (Player)user).isCreative()) {
                RandomSource random;
                RandomSource randomSource = random = user == null ? GTValues.RNG : user.getRandom();
                if (tool.isElectric()) {
                    int electricDamage = damage * ConfigHolder.INSTANCE.machines.energyUsageMultiplier;
                    IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
                    if (electricItem != null) {
                        electricItem.discharge(electricDamage, tool.getElectricTier(), true, false, false);
                        if (electricItem.getCharge() > 0L && random.nextInt(100) >= ConfigHolder.INSTANCE.tools.rngDamageElectricTools) {
                            return;
                        }
                    } else {
                        throw new IllegalStateException("Electric tool does not have an attached electric item capability.");
                    }
                }
                int unbreakingLevel = stack.getEnchantmentLevel(Enchantments.UNBREAKING);
                int negated = 0;
                for (int k = 0; unbreakingLevel > 0 && k < damage; ++k) {
                    if (!DigDurabilityEnchantment.shouldIgnoreDurabilityDrop((ItemStack)stack, (int)unbreakingLevel, (RandomSource)random)) continue;
                    ++negated;
                }
                if ((damage -= negated) <= 0) {
                    return;
                }
                int newDurability = stack.getDamageValue() + damage;
                if (user instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)user;
                    CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(serverPlayer, stack, newDurability);
                }
                stack.setDamageValue(newDurability);
                if (newDurability > stack.getMaxDamage()) {
                    if (user instanceof Player) {
                        Player player2 = (Player)user;
                        Stat stat = Stats.ITEM_BROKEN.get((Object)stack.getItem());
                        player2.awardStat(stat);
                    }
                    if (user != null) {
                        user.breakItem(stack);
                        user.broadcastBreakEvent(user.isUsingItem() ? user.getUsedItemHand() : InteractionHand.MAIN_HAND);
                    }
                    stack.shrink(1);
                }
            }
        }
    }

    public static void playToolSound(@Nullable GTToolType toolType, ServerPlayer player) {
        if (toolType != null && toolType.soundEntry != null) {
            toolType.soundEntry.playOnServer(player.level(), (Vec3i)player.blockPosition());
        }
    }

    public static ItemStack getAndSetToolData(GTToolType toolType, Material material, int maxDurability, int harvestLevel, float toolSpeed, float attackDamage) {
        ItemProviderEntry tool = (ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)material, (Object)toolType);
        if (tool == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ((IGTTool)tool.get()).getRaw();
        stack.getOrCreateTag().putInt(HIDE_FLAGS, 2);
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        toolTag.putInt(MAX_DURABILITY_KEY, maxDurability);
        toolTag.putInt(HARVEST_LEVEL_KEY, harvestLevel);
        toolTag.putFloat(TOOL_SPEED_KEY, toolSpeed);
        toolTag.putFloat(ATTACK_DAMAGE_KEY, attackDamage);
        ToolProperty toolProperty = material.getProperty(PropertyKey.TOOL);
        if (toolProperty != null) {
            for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(toolProperty.getEnchantments())) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                if (!((IGTTool)tool.get()).definition$canApplyAtEnchantingTable(stack, enchantment)) continue;
                stack.enchant(enchantment, entry.getIntValue());
            }
        }
        return stack;
    }

    public static Map<Enchantment, Integer> joinEnchantments(ItemStack stack, Map<Enchantment, Integer> enchantments) {
        Map original = EnchantmentHelper.getEnchantments((ItemStack)stack);
        if (enchantments.isEmpty()) {
            return original;
        }
        if (original.isEmpty()) {
            return enchantments;
        }
        Object2IntLinkedOpenHashMap joined = new Object2IntLinkedOpenHashMap(original);
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            joined.mergeInt((Object)entry.getKey(), entry.getValue().intValue(), Integer::max);
        }
        return joined;
    }

    public static boolean areaOfEffectBlockBreakRoutine(ItemStack stack, ServerPlayer player, BlockPos targeted) {
        int currentDurability = stack.getDamageValue();
        int maximumDurability = stack.getMaxDamage();
        int remainingUses = maximumDurability - currentDurability;
        List<BlockPos> harvestableBlocks = ToolHelper.getHarvestableBlocks(stack, (Player)player);
        if (!harvestableBlocks.isEmpty()) {
            for (BlockPos pos : harvestableBlocks) {
                IGTTool gtTool;
                if (!ToolHelper.breakBlockRoutine(player, stack, pos, pos.equals((Object)targeted))) {
                    return true;
                }
                Item item = stack.getItem();
                if (item instanceof IGTTool && !(gtTool = (IGTTool)item).isElectric() && --remainingUses == 0) {
                    return true;
                }
                if (ItemStack.isSameItem((ItemStack)player.getMainHandItem(), (ItemStack)stack)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static AoESymmetrical getMaxAoEDefinition(ItemStack stack) {
        return AoESymmetrical.readMax(ToolHelper.getBehaviorsTag(stack));
    }

    public static AoESymmetrical getAoEDefinition(ItemStack stack) {
        return AoESymmetrical.read(ToolHelper.getBehaviorsTag(stack), ToolHelper.getMaxAoEDefinition(stack));
    }

    public static List<BlockPos> iterateAoE(AoESymmetrical aoeDefinition, Predicate<UseOnContext> predicate, UseOnContext context) {
        int aoeRowEnd;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        Direction hitFace = context.getClickedFace();
        ItemStack stack = context.getItemInHand();
        Direction playerFacing = player != null ? player.getDirection() : Direction.NORTH;
        Direction depthDirection = hitFace.getOpposite();
        Direction topDirection = Direction.UP;
        Direction sideDirection = hitFace;
        int aoeRowStart = aoeDefinition.row == 0 ? 0 : -1;
        int n = aoeRowEnd = aoeDefinition.row == 0 ? 0 : aoeDefinition.row * 2 - 1;
        if (hitFace.getAxis().isVertical()) {
            topDirection = playerFacing;
            sideDirection = playerFacing;
            aoeRowStart = -aoeDefinition.row;
            aoeRowEnd = aoeDefinition.row;
        }
        sideDirection = sideDirection.getClockWise();
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int depth = 0; depth <= aoeDefinition.layer; ++depth) {
            for (int top = aoeRowEnd; top >= aoeRowStart; --top) {
                for (int side = -aoeDefinition.column; side <= aoeDefinition.column; ++side) {
                    UseOnContext posContext;
                    BlockPos pos = context.getClickedPos().relative(depthDirection, depth).relative(topDirection, top).relative(sideDirection, side);
                    if (player != null && !player.mayUseItemAt(pos.relative(hitFace), hitFace, stack) || !predicate.test(posContext = new UseOnContext(level, player, context.getHand(), stack, context.getHitResult().withPosition(pos)))) continue;
                    validPositions.add(pos);
                }
            }
        }
        return validPositions;
    }

    public static List<BlockPos> getHarvestableBlocks(AoESymmetrical aoeDefinition, UseOnContext context) {
        return ToolHelper.iterateAoE(aoeDefinition, ToolHelper::isBlockAoEHarvestable, context);
    }

    private static boolean isBlockAoEHarvestable(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        if (level.getBlockState(pos).isAir()) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof LiquidBlock) {
            return false;
        }
        BlockPos hitBlockPos = context.getClickedPos();
        BlockState hitBlockState = level.getBlockState(hitBlockPos);
        if (state.getDestroySpeed((BlockGetter)level, pos) < 0.0f || state.getDestroySpeed((BlockGetter)level, pos) - hitBlockState.getDestroySpeed((BlockGetter)level, hitBlockPos) > 8.0f) {
            return false;
        }
        return stack.getItem().isCorrectToolForDrops(stack, state);
    }

    public static void applyHammerDropConversion(ServerLevel world, BlockPos pos, ItemStack tool, BlockState state, List<ItemStack> drops, int fortune, float dropChance, RandomSource random) {
        if (ToolHelper.is(tool, GTToolType.HARD_HAMMER)) {
            List<ItemStack> silktouchDrops = ToolHelper.getSilkTouchDrop(world, pos, state);
            for (ItemStack silktouchDrop : silktouchDrops) {
                if (silktouchDrop.isEmpty()) continue;
                DummyMachineBlockEntity be = new DummyMachineBlockEntity(1, GTRecipeTypes.FORGE_HAMMER_RECIPES, GTMachineUtils.defaultTankSizeFunction, Collections.emptyList(), new Object[0]);
                RecipeHandlerList dummyInputs = RecipeHandlerList.of(IO.IN, new InfiniteEnergyContainer(be.getMetaMachine(), GTValues.V[1], GTValues.V[1], 1L, GTValues.V[1], 1L), new NotifiableItemStackHandler(be.getMetaMachine(), 1, IO.IN, IO.IN, slots -> new CustomItemStackHandler(silktouchDrop)));
                RecipeHandlerList dummyOutputs = RecipeHandlerList.of(IO.OUT, new NotifiableItemStackHandler(be.getMetaMachine(), 2, IO.OUT));
                be.getMetaMachine().reinitializeHandlers(List.of(dummyInputs, dummyOutputs));
                Iterator<GTRecipe> hammerRecipes = GTRecipeTypes.FORGE_HAMMER_RECIPES.searchRecipe(be.metaMachine, r -> RecipeHelper.matchContents(be.metaMachine, r).isSuccess());
                GTRecipe hammerRecipe = !hammerRecipes.hasNext() ? null : hammerRecipes.next();
                if (hammerRecipe == null || !RecipeHelper.handleRecipeIO(be.metaMachine, hammerRecipe, IO.IN, be.getMetaMachine().recipeLogic.getChanceCaches()).isSuccess()) continue;
                drops.clear();
                TagPrefix prefix = ChemicalHelper.getPrefix((ItemLike)silktouchDrop.getItem());
                if (prefix.isEmpty()) {
                    for (Content output : hammerRecipe.getOutputContents(ItemRecipeCapability.CAP)) {
                        if (!(dropChance >= 1.0f) && !(random.nextFloat() <= dropChance)) continue;
                        drops.add(SizedIngredient.copy((Ingredient)ItemRecipeCapability.CAP.of(output.content)).getItems()[0]);
                    }
                    continue;
                }
                if (!TagPrefix.ORES.containsKey(prefix)) continue;
                for (Content content : hammerRecipe.getOutputContents(ItemRecipeCapability.CAP)) {
                    ItemStack output;
                    if (!(dropChance >= 1.0f) && !(random.nextFloat() <= dropChance) || ChemicalHelper.getPrefix((ItemLike)(output = ((Ingredient)ItemRecipeCapability.CAP.of(content.content)).getItems()[0]).getItem()) != TagPrefix.crushed) continue;
                    output = output.copy();
                    if (fortune > 0) {
                        output.grow(random.nextInt(fortune));
                    }
                    drops.add(output);
                }
            }
        }
    }

    public static boolean breakBlockRoutine(ServerPlayer player, ItemStack tool, BlockPos pos, boolean playSound) {
        boolean successful;
        if (ToolHelper.isTool(tool, GTToolType.SHEARS) && ToolHelper.shearBlockRoutine(player, tool, pos) == 0) {
            return false;
        }
        Level world = player.level();
        boolean canBreak = ToolHelper.onBlockBreakEvent(world, player.gameMode.getGameModeForPlayer(), player, pos);
        if (!canBreak) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        BlockEntity tile = world.getBlockEntity(pos);
        if (block instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
            world.sendBlockUpdated(pos, state, state, 3);
            return false;
        }
        if (player.blockActionRestricted(world, pos, player.gameMode.getGameModeForPlayer())) {
            return false;
        }
        if (player.isCreative()) {
            return ToolHelper.removeBlockRoutine(state, world, player, pos, playSound);
        }
        world.levelEvent((Player)player, 2001, pos, Block.getId((BlockState)state));
        ItemStack copiedTool = tool.copy();
        boolean canHarvest = player.hasCorrectToolForDrops(state);
        if (!tool.isEmpty()) {
            tool.mineBlock(world, state, pos, (Player)player);
            if (tool.isEmpty() && !copiedTool.isEmpty()) {
                ToolHelper.onPlayerDestroyItem((Player)player, copiedTool, InteractionHand.MAIN_HAND);
            }
        }
        if ((successful = ToolHelper.removeBlockRoutine(null, world, player, pos, playSound)) && canHarvest) {
            block.playerDestroy(world, (Player)player, pos, state, tile, copiedTool);
        }
        return successful;
    }

    public static boolean onBlockBreakEvent(Level level, GameType gameType, ServerPlayer player, BlockPos pos) {
        return ForgeHooks.onBlockBreakEvent((Level)level, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos) != -1;
    }

    public static void onPlayerDestroyItem(Player player, ItemStack stack, InteractionHand hand) {
        ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
    }

    public static double getPlayerBlockReach(@NotNull Player player) {
        return player.getBlockReach();
    }

    public static boolean isCorrectTierForDrops(BlockState state, int tier) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)ToolHelper.getTier(tier), (BlockState)state);
    }

    private static Tier getTier(int harvestLevel) {
        List<Tier> tiers = TierSortingRegistry.getSortedTiers().stream().filter(tier -> tier.getLevel() == harvestLevel).toList();
        return !tiers.isEmpty() ? tiers.get(tiers.size() - 1) : Tiers.WOOD;
    }

    public static boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return itemstack.onBlockStartBreak(pos, player);
    }

    public static boolean removeBlockRoutine(@Nullable BlockState state, Level world, ServerPlayer player, BlockPos pos, boolean playSound) {
        state = state == null ? world.getBlockState(pos) : state;
        state.getBlock().playerWillDestroy(world, pos, state, (Player)player);
        boolean successful = world.removeBlock(pos, false);
        if (playSound) {
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        if (successful) {
            state.getBlock().destroy((LevelAccessor)world, pos, state);
        }
        return successful;
    }

    public static List<BlockPos> getHarvestableBlocks(ItemStack stack, Player player) {
        InteractionHand hand;
        GTToolType toolType;
        if (!ToolHelper.hasBehaviorsTag(stack)) {
            return List.of();
        }
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition.isZero()) {
            return List.of();
        }
        BlockHitResult hitResult = ToolHelper.getPlayerDefaultRaytrace(player);
        Item item = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (item instanceof GTToolItem) {
            GTToolItem toolItem = (GTToolItem)item;
            v0 = toolItem.toolType;
        } else {
            v0 = toolType = null;
        }
        if (toolType == null) {
            return Collections.emptyList();
        }
        Object object = hand = ToolHelper.is(player.getItemInHand(InteractionHand.MAIN_HAND), toolType) ? InteractionHand.MAIN_HAND : null;
        if (hand == null) {
            return Collections.emptyList();
        }
        UseOnContext context = new UseOnContext(player, hand, hitResult);
        return ToolHelper.getHarvestableBlocks(aoeDefinition, context);
    }

    public static BlockHitResult getPlayerDefaultRaytrace(@NotNull Player player) {
        return ToolHelper.entityPickBlock((Entity)player, ToolHelper.getPlayerBlockReach(player), 1.0f, false);
    }

    public static BlockHitResult entityPickBlock(Entity entity, double hitDistance, float partialTicks, boolean hitFluids) {
        Vec3 eyePos = entity.getEyePosition(partialTicks);
        Vec3 lookVec = entity.getViewVector(partialTicks);
        Vec3 maxDistance = eyePos.add(lookVec.x * hitDistance, lookVec.y * hitDistance, lookVec.z * hitDistance);
        ClipContext context = new ClipContext(eyePos, maxDistance, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity);
        return entity.level().clip(context);
    }

    public static void onActionDone(@Nullable Player player, @NotNull ItemStack stack, @NotNull Level level, @NotNull Vec3 pos) {
        IGTTool tool = (IGTTool)stack.getItem();
        ToolHelper.damageItem(stack, (LivingEntity)player);
        if (tool.getSound() != null) {
            level.playSound(player, pos.x, pos.y, pos.z, tool.getSound().getMainEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @NotNull
    public static Set<GTToolType> getToolTypes(ItemStack tool) {
        HashSet<GTToolType> types = new HashSet<GTToolType>();
        Item item = tool.getItem();
        if (item instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)item;
            return gtTool.getToolClasses(tool);
        }
        for (GTToolType toolType : GTToolType.getTypes().values()) {
            if (!toolType.matchTags.stream().anyMatch(arg_0 -> ((ItemStack)tool).is(arg_0))) continue;
            types.add(toolType);
        }
        return types;
    }

    @NotNull
    public static Set<GTToolType> getCraftingToolTypes(ItemStack tool) {
        HashSet<GTToolType> types = new HashSet<GTToolType>();
        Item item = tool.getItem();
        if (item instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)item;
            return gtTool.getToolClasses(tool);
        }
        for (GTToolType toolType : GTToolType.getTypes().values()) {
            if (!toolType.craftingTags.stream().anyMatch(arg_0 -> ((ItemStack)tool).is(arg_0))) continue;
            types.add(toolType);
        }
        return types;
    }

    public static boolean isTool(ItemStack tool, GTToolType ... toolClasses) {
        for (GTToolType toolType : toolClasses) {
            if (!toolType.matchTags.stream().anyMatch(arg_0 -> ((ItemStack)tool).is(arg_0))) continue;
            return true;
        }
        Item item = tool.getItem();
        if (item instanceof IGTTool) {
            IGTTool igtTool = (IGTTool)item;
            if (toolClasses.length == 1) {
                return igtTool.getToolClasses(tool).contains(toolClasses[0]);
            }
            for (GTToolType toolClass : igtTool.getToolClasses(tool)) {
                for (GTToolType specified : toolClasses) {
                    if (!toolClass.equals(specified)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isToolEffective(BlockState state, Set<GTToolType> toolClasses, int harvestLevel) {
        if (toolClasses.stream().anyMatch(type -> type.harvestTags.stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0)))) {
            return ToolHelper.isCorrectTierForDrops(state, harvestLevel);
        }
        return false;
    }

    public static void damageItemWhenCrafting(@NotNull ItemStack stack, @Nullable LivingEntity entity) {
        int damage = 2;
        if (stack.getItem() instanceof IGTTool) {
            damage = ((IGTTool)stack.getItem()).getToolStats().getToolDamagePerCraft(stack);
        } else if (stack.getTags().anyMatch(s -> s.location().getPath().startsWith("tool") || s.location().getPath().startsWith("crafting_tool"))) {
            damage = 1;
        }
        ToolHelper.damageItem(stack, entity, damage);
    }

    public static void damageItem(@NotNull ItemStack stack, @Nullable LivingEntity entity) {
        ToolHelper.damageItem(stack, entity, 1);
    }

    public static float getDestroySpeed(BlockState state, Set<GTToolType> toolClasses) {
        Block block;
        if (toolClasses.contains(GTToolType.SWORD) && (block = state.getBlock()) instanceof WebBlock) {
            return 15.0f;
        }
        return -1.0f;
    }

    public static int shearBlockRoutine(ServerPlayer player, ItemStack tool, BlockPos pos) {
        IForgeShearable shearable;
        ServerLevel world;
        BlockState state;
        Block block;
        if (!player.isCreative() && (block = (state = (world = player.serverLevel()).getBlockState(pos)).getBlock()) instanceof IForgeShearable && (shearable = (IForgeShearable)block).isShearable(tool, (Level)world, pos)) {
            List shearedDrops = shearable.onSheared((Player)player, tool, (Level)world, pos, tool.getEnchantmentLevel(Enchantments.BLOCK_FORTUNE));
            boolean relocateMinedBlocks = ToolHelper.hasBehaviorsTag(tool) && ToolHelper.getBehaviorsTag(tool).getBoolean(RELOCATE_MINED_BLOCKS_KEY);
            Iterator iter = shearedDrops.iterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                if (relocateMinedBlocks && player.addItem(stack)) {
                    iter.remove();
                    continue;
                }
                float f = 0.7f;
                double xo = (double)(world.random.nextFloat() * f) + 0.15;
                double yo = (double)(world.random.nextFloat() * f) + 0.15;
                double zo = (double)(world.random.nextFloat() * f) + 0.15;
                ItemEntity entityItem = new ItemEntity((Level)world, (double)pos.getX() + xo, (double)pos.getY() + yo, (double)pos.getZ() + zo, stack);
                entityItem.setDefaultPickUpDelay();
                world.addFreshEntity((Entity)entityItem);
            }
            ToolHelper.damageItem(tool, (LivingEntity)player, 1);
            player.awardStat(Stats.BLOCK_MINED.get((Object)((Block)shearable)));
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            return tool.isEmpty() ? 0 : 1;
        }
        return -1;
    }

    @NotNull
    public static List<ItemStack> getSilkTouchDrop(ServerLevel world, BlockPos origin, @NotNull BlockState state) {
        ItemStack tool = ((IGTTool)((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)GTMaterials.Neutronium, (Object)GTToolType.PICKAXE)).get()).get();
        tool.enchant(Enchantments.SILK_TOUCH, 1);
        return state.getDrops(new LootParams.Builder(world).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)origin)).withParameter(LootContextParams.TOOL, (Object)tool));
    }
}

