/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighlight;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAsyncAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoPersistBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IRPCBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import org.jetbrains.annotations.NotNull;

public interface IMachineBlockEntity
extends IToolGridHighlight,
IAsyncAutoSyncBlockEntity,
IRPCBlockEntity,
IAutoPersistBlockEntity,
IPaintable,
IForgeBlockEntity {
    public static final ModelProperty<BlockAndTintGetter> MODEL_DATA_LEVEL = new ModelProperty();
    public static final ModelProperty<BlockPos> MODEL_DATA_POS = new ModelProperty();

    default public BlockEntity self() {
        return (BlockEntity)this;
    }

    default public Level level() {
        return this.self().getLevel();
    }

    default public BlockPos pos() {
        return this.self().getBlockPos();
    }

    default public void notifyBlockUpdate() {
        if (this.level() != null) {
            this.level().updateNeighborsAt(this.pos(), this.level().getBlockState(this.pos()).getBlock());
        }
    }

    default public void scheduleRenderUpdate() {
        BlockPos pos = this.pos();
        if (this.level() != null) {
            BlockState state = this.level().getBlockState(pos);
            if (this.level().isClientSide) {
                this.level().sendBlockUpdated(pos, state, state, 8);
                this.self().requestModelDataUpdate();
            } else {
                this.level().blockEvent(pos, state.getBlock(), 1, 0);
            }
        }
    }

    @NotNull
    default public ModelData getModelData() {
        ModelData.Builder data = super.getModelData().derive();
        this.getMetaMachine().updateModelData(data);
        return data.build();
    }

    default public long getOffsetTimer() {
        if (this.level() == null) {
            return this.getOffset();
        }
        if (this.level().isClientSide()) {
            return GTValues.CLIENT_TIME + this.getOffset();
        }
        MinecraftServer server = this.level().getServer();
        if (server != null) {
            return (long)server.getTickCount() + this.getOffset();
        }
        return this.getOffset();
    }

    default public MachineDefinition getDefinition() {
        Block block = this.self().getBlockState().getBlock();
        if (block instanceof IMachineBlock) {
            IMachineBlock machineBlock = (IMachineBlock)block;
            return machineBlock.getDefinition();
        }
        throw new IllegalStateException("MetaMachineBlockEntity is created for an un available block: " + String.valueOf(this.self().getBlockState().getBlock()));
    }

    public MachineRenderState getRenderState();

    public void setRenderState(MachineRenderState var1);

    public MetaMachine getMetaMachine();

    public long getOffset();

    public MultiManagedStorage getRootStorage();

    default public void saveCustomPersistedData(CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        this.getMetaMachine().saveCustomPersistedData(tag, forDrop);
    }

    default public void loadCustomPersistedData(CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        this.getMetaMachine().loadCustomPersistedData(tag);
    }

    @Override
    default public int getPaintingColor() {
        return this.getMetaMachine().getPaintingColor();
    }

    @Override
    default public void setPaintingColor(int color) {
        this.getMetaMachine().setPaintingColor(color);
    }

    @Override
    default public int getDefaultPaintingColor() {
        return this.getMetaMachine().getDefaultPaintingColor();
    }
}

