/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IHazardParticleContainer;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public interface IEnvironmentalHazardEmitter
extends IMachineFeature {
    default public MedicalCondition getConditionToEmit() {
        return GTMedicalConditions.CARBON_MONOXIDE_POISONING;
    }

    public float getHazardStrengthPerOperation();

    default public void spreadEnvironmentalHazard() {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        Level level = this.self().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            IHazardParticleContainer container = GTCapabilityHelper.getHazardContainer((Level)serverLevel, this.self().getPos().relative(this.self().getFrontFacing()), this.self().getFrontFacing().getOpposite());
            if (container != null && container.getHazardCanBeInserted(this.getConditionToEmit()) > this.getHazardStrengthPerOperation()) {
                container.addHazard(this.getConditionToEmit(), this.getHazardStrengthPerOperation());
                return;
            }
            EnvironmentalHazardSavedData savedData = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
            savedData.addZone(this.self().getPos(), this.getHazardStrengthPerOperation(), true, HazardProperty.HazardTrigger.INHALATION, this.getConditionToEmit());
        }
    }
}

