/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public interface IExhaustVentMachine
extends IMachineFeature {
    public static final EnumProperty<RelativeDirection> VENT_DIRECTION_PROPERTY = GTMachineModelProperties.VENT_DIRECTION;

    @NotNull
    public Direction getVentingDirection();

    public boolean isNeedsVenting();

    public void setNeedsVenting(boolean var1);

    public void markVentingComplete();

    public float getVentingDamage();

    default public boolean checkVenting() {
        if (this.isNeedsVenting()) {
            this.tryDoVenting(this.self().getLevel(), this.self().getPos());
        }
        return !this.isNeedsVenting();
    }

    default public boolean isVentingBlocked() {
        Level level = this.self().getLevel();
        Direction ventingSide = this.getVentingDirection();
        BlockPos ventingBlockPos = this.self().getPos().relative(ventingSide);
        BlockState state = level.getBlockState(ventingBlockPos);
        return state.canOcclude() || Shapes.blockOccudes((VoxelShape)state.getCollisionShape((BlockGetter)level, ventingBlockPos), (VoxelShape)Shapes.block(), (Direction)ventingSide.getOpposite());
    }

    default public void tryDoVenting(@NotNull Level level, @NotNull BlockPos pos) {
        if (!this.isNeedsVenting()) {
            return;
        }
        if (!this.isVentingBlocked()) {
            this.performVenting(level, pos);
            return;
        }
        BlockPos ventingPos = pos.relative(this.getVentingDirection());
        if (GTUtil.tryBreakSnow(level, ventingPos, level.getBlockState(ventingPos), false)) {
            this.performVenting(level, pos);
        }
    }

    private void performVenting(@NotNull Level level, @NotNull BlockPos pos) {
        this.doVentingDamage(level, pos);
        Direction ventingDirection = this.getVentingDirection();
        double posX = (double)pos.getX() + 0.5 + (double)ventingDirection.getStepX() * 0.6;
        double posY = (double)pos.getY() + 0.5 + (double)ventingDirection.getStepY() * 0.6;
        double posZ = (double)pos.getZ() + 0.5 + (double)ventingDirection.getStepZ() * 0.6;
        this.createVentingParticles(level, posX, posY, posZ);
        if (ConfigHolder.INSTANCE.machines.machineSounds) {
            this.playVentingSound(level, posX, posY, posZ);
        }
        this.markVentingComplete();
    }

    default public void doVentingDamage(@NotNull Level level, @NotNull BlockPos pos) {
        for (LivingEntity entity2 : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos.relative(this.getVentingDirection())), entity -> {
            Player player;
            return !(entity instanceof Player) || !(player = (Player)entity).isSpectator() && !player.isCreative();
        })) {
            entity2.hurt(GTDamageTypes.HEAT.source((LevelAccessor)level), this.getVentingDamage());
        }
    }

    default public void createVentingParticles(@NotNull Level level, double posX, double posY, double posZ) {
        Direction ventingDirection = this.getVentingDirection();
        int count = 7 + level.random.nextInt(3);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, posX, posY, posZ, count, (double)ventingDirection.getStepX() / 2.0, (double)ventingDirection.getStepY() / 2.0, (double)ventingDirection.getStepZ() / 2.0, 0.1);
        } else {
            for (int i = 0; i < count; ++i) {
                double d1 = level.random.nextGaussian() * (double)ventingDirection.getStepX() / 2.0;
                double d3 = level.random.nextGaussian() * (double)ventingDirection.getStepY() / 2.0;
                double d5 = level.random.nextGaussian() * (double)ventingDirection.getStepZ() / 2.0;
                double d6 = level.random.nextGaussian() * 0.1;
                double d7 = level.random.nextGaussian() * 0.1;
                double d8 = level.random.nextGaussian() * 0.1;
                try {
                    level.addParticle((ParticleOptions)ParticleTypes.CLOUD, posX + d1, posY + d3, posZ + d5, d6, d7, d8);
                    continue;
                }
                catch (Throwable throwable) {
                    GTCEu.LOGGER.warn("Could not spawn particle effect {}", (Object)ParticleTypes.CLOUD);
                    return;
                }
            }
        }
    }

    default public void playVentingSound(@NotNull Level level, double posX, double posY, double posZ) {
        level.playSound(null, posX, posY, posZ, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

