/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;

public interface IExplosionMachine
extends IMachineFeature {
    default public void checkWeatherOrTerrainExplosion(float explosionPower, double additionalFireChance) {
        if (!this.shouldWeatherOrTerrainExplosion()) {
            return;
        }
        MetaMachine machine = this.self();
        Level level = machine.getLevel();
        BlockPos pos = machine.getPos();
        if (GTValues.RNG.nextInt(1000) == 0) {
            for (Direction side : GTUtil.DIRECTIONS) {
                FluidState fluidState = level.getBlockState(pos.relative(side)).getFluidState();
                if (fluidState.isEmpty()) continue;
                this.doExplosion(explosionPower);
                return;
            }
        }
        if (GTValues.RNG.nextInt(1000) == 0 && (level.isRainingAt(pos) || level.isRainingAt(pos.east()) || level.isRainingAt(pos.west()) || level.isRainingAt(pos.north()) || level.isRainingAt(pos.south()))) {
            if (level.isThundering() && GTValues.RNG.nextInt(3) == 0) {
                this.doExplosion(explosionPower);
            } else if (GTValues.RNG.nextInt(10) == 0) {
                this.doExplosion(explosionPower);
            } else {
                this.setOnFire(additionalFireChance);
            }
        }
    }

    default public void doExplosion(float explosionPower) {
        this.doExplosion(this.self().getPos(), explosionPower);
    }

    default public void doExplosion(BlockPos pos, float explosionPower) {
        MetaMachine machine = this.self();
        Level level = machine.getLevel();
        level.removeBlock(pos, false);
        level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, explosionPower, ConfigHolder.INSTANCE.machines.doesExplosionDamagesTerrain ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    default public void setOnFire(double additionalFireChance) {
        MetaMachine machine = this.self();
        Level level = machine.getLevel();
        BlockPos pos = machine.getPos();
        boolean isFirstFireSpawned = false;
        for (Direction side : GTUtil.DIRECTIONS) {
            if (!level.isEmptyBlock(pos.relative(side))) continue;
            if (!isFirstFireSpawned) {
                level.setBlock(pos.relative(side), Blocks.FIRE.defaultBlockState(), 11);
                if (level.isEmptyBlock(pos.relative(side))) continue;
                isFirstFireSpawned = true;
                continue;
            }
            if (!(additionalFireChance >= GTValues.RNG.nextDouble() * 100.0)) continue;
            level.setBlock(pos.relative(side), Blocks.FIRE.defaultBlockState(), 11);
        }
    }

    default public boolean shouldWeatherOrTerrainExplosion() {
        return true;
    }
}

