/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.FancySelectorConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public interface IVoidable
extends IMachineFeature {
    default public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        return this.getVoidingMode().canVoid(capability) || this.self().getDefinition().getRecipeOutputLimits().getOrDefault(capability, -1) == 0;
    }

    default public Reference2IntMap<RecipeCapability<?>> getOutputLimits() {
        return this.self().getDefinition().getRecipeOutputLimits();
    }

    default public void setVoidingMode(VoidingMode mode) {
    }

    default public VoidingMode getVoidingMode() {
        return VoidingMode.VOID_NONE;
    }

    public static void attachConfigurators(ConfiguratorPanel configuratorPanel, IVoidable controller) {
        IFancyConfigurator[] iFancyConfiguratorArray = new IFancyConfigurator[1];
        iFancyConfiguratorArray[0] = new FancySelectorConfigurator((Enum[])VoidingMode.VALUES, (Enum)controller.getVoidingMode(), controller::setVoidingMode).setTooltip(m -> List.of(Component.translatable((String)"gtceu.gui.multiblock.voiding_mode"), Component.translatable((String)m.localeName)));
        configuratorPanel.attachConfigurators(iFancyConfiguratorArray);
    }

    public static enum VoidingMode implements StringRepresentable,
    EnumSelectorWidget.SelectableEnum
    {
        VOID_NONE("gtceu.gui.no_voiding", cap -> false),
        VOID_ITEMS("gtceu.gui.item_voiding", cap -> cap == ItemRecipeCapability.CAP),
        VOID_FLUIDS("gtceu.gui.fluid_voiding", cap -> cap == FluidRecipeCapability.CAP),
        VOID_ITEMS_FLUIDS("gtceu.gui.all_voiding", cap -> cap == ItemRecipeCapability.CAP || cap == FluidRecipeCapability.CAP);

        public static final VoidingMode[] VALUES;
        private final String localeName;
        private final IGuiTexture icon;
        private final Predicate<RecipeCapability<?>> canVoid;

        private VoidingMode(String name, Predicate<RecipeCapability<?>> canVoid) {
            this.localeName = name;
            this.canVoid = canVoid;
            this.icon = GuiTextures.BUTTON_VOID_MULTIBLOCK.getSubTexture(0.0, (double)this.ordinal() * 0.25, 1.0, 0.25);
        }

        public boolean canVoid(RecipeCapability<?> capability) {
            return this.canVoid.test(capability);
        }

        @NotNull
        public String getSerializedName() {
            return this.localeName;
        }

        @Override
        @NotNull
        public String getTooltip() {
            return this.localeName;
        }

        @Override
        @Generated
        public IGuiTexture getIcon() {
            return this.icon;
        }

        static {
            VALUES = VoidingMode.values();
        }
    }
}

