/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IHazardParticleContainer;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.feature.IEnvironmentalHazardEmitter;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTParticleTypes;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public interface IMufflerMachine
extends IMultiPart,
IEnvironmentalHazardEmitter {
    public void recoverItemsTable(ItemStack ... var1);

    default public boolean isFrontFaceFree() {
        BlockPos frontPos = this.self().getPos().relative(this.self().getFrontFacing());
        return this.self().getLevel().getBlockState(frontPos).isAir() || GTCapabilityHelper.getHazardContainer(this.self().getLevel(), frontPos, this.self().getFrontFacing().getOpposite()) != null;
    }

    default public void emitPollutionParticles() {
        BlockPos pos = this.self().getPos();
        Direction facing = this.self().getFrontFacing();
        IHazardParticleContainer container = GTCapabilityHelper.getHazardContainer(this.self().getLevel(), pos.relative(facing), facing.getOpposite());
        if (container != null) {
            return;
        }
        Vec3 center = pos.getCenter();
        float offset = 0.75f;
        float xPos = (float)(center.x + (double)((float)facing.getStepX() * offset) + (double)((GTValues.RNG.nextFloat() - 0.5f) * 0.35f));
        float yPos = (float)(center.y + (double)((float)facing.getStepY() * offset) + (double)((GTValues.RNG.nextFloat() - 0.5f) * 0.35f));
        float zPos = (float)(center.z + (double)((float)facing.getStepZ() * offset) + (double)((GTValues.RNG.nextFloat() - 0.5f) * 0.35f));
        float ySpd = (float)facing.getStepY() + (GTValues.RNG.nextFloat() - 0.15f) * 0.5f;
        float xSpd = (float)facing.getStepX() + (GTValues.RNG.nextFloat() - 0.5f) * 0.5f;
        float zSpd = (float)facing.getStepZ() + (GTValues.RNG.nextFloat() - 0.5f) * 0.5f;
        this.self().getLevel().addParticle((ParticleOptions)GTParticleTypes.MUFFLER_PARTICLE.get(), (double)xPos, (double)yPos, (double)zPos, (double)xSpd, (double)ySpd, (double)zSpd);
    }

    @Override
    default public GTRecipe modifyRecipe(GTRecipe recipe) {
        if (!this.isFrontFaceFree()) {
            return null;
        }
        return IMultiPart.super.modifyRecipe(recipe);
    }

    @Override
    default public float getHazardStrengthPerOperation() {
        float f;
        float outputAmount = 2.5f;
        IMufflerMachine iMufflerMachine = this;
        if (iMufflerMachine instanceof TieredPartMachine) {
            TieredPartMachine tiered = (TieredPartMachine)((Object)iMufflerMachine);
            f = outputAmount / (float)Math.max(tiered.getTier(), 1);
        } else {
            f = outputAmount;
        }
        return f;
    }

    @Override
    default public boolean afterWorking(IWorkableMultiController controller) {
        this.spreadEnvironmentalHazard();
        Supplier<ItemStack[]> supplier = controller.self().getDefinition().getRecoveryItems();
        if (supplier != null) {
            this.recoverItemsTable(supplier.get());
        }
        return IMultiPart.super.afterWorking(controller);
    }

    @Override
    default public void attachFancyTooltipsToController(IMultiController controller, TooltipsPanel tooltipsPanel) {
        this.attachTooltips(tooltipsPanel);
    }

    @Override
    default public void attachTooltips(TooltipsPanel tooltipsPanel) {
        tooltipsPanel.attachTooltips(new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(Component.translatable((String)"gtceu.multiblock.universal.muffler_obstructed").setStyle(Style.EMPTY.withColor(ChatFormatting.RED))), () -> !this.isFrontFaceFree(), () -> null));
    }
}

