/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableEnergyContainer
extends NotifiableRecipeHandlerTrait<EnergyStack>
implements IEnergyContainer {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableEnergyContainer.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    protected IO handlerIO;
    @Persisted
    @DescSynced
    protected long energyStored;
    private long energyCapacity;
    private long inputVoltage;
    private long inputAmperage;
    private long outputVoltage;
    private long outputAmperage;
    private Predicate<Direction> sideInputCondition;
    private Predicate<Direction> sideOutputCondition;
    protected long amps;
    protected long lastTimeStamp = Long.MIN_VALUE;
    @Nullable
    protected TickableSubscription outputSubs;
    @Nullable
    protected TickableSubscription updateSubs;
    protected long lastEnergyInputPerSec = 0L;
    protected long lastEnergyOutputPerSec = 0L;
    protected long energyInputPerSec = 0L;
    protected long energyOutputPerSec = 0L;

    public NotifiableEnergyContainer(MetaMachine machine, long maxCapacity, long maxInputVoltage, long maxInputAmperage, long maxOutputVoltage, long maxOutputAmperage) {
        super(machine);
        boolean isOut;
        this.energyCapacity = maxCapacity;
        this.inputVoltage = maxInputVoltage;
        this.inputAmperage = maxInputAmperage;
        this.outputVoltage = maxOutputVoltage;
        this.outputAmperage = maxOutputAmperage;
        boolean isIn = this.inputVoltage != 0L && this.inputAmperage != 0L;
        boolean bl = isOut = this.outputVoltage != 0L && this.outputAmperage != 0L;
        this.handlerIO = isIn && isOut ? IO.BOTH : (isIn ? IO.IN : (isOut ? IO.OUT : IO.NONE));
    }

    public static NotifiableEnergyContainer emitterContainer(MetaMachine machine, long maxCapacity, long maxOutputVoltage, long maxOutputAmperage) {
        return new NotifiableEnergyContainer(machine, maxCapacity, 0L, 0L, maxOutputVoltage, maxOutputAmperage);
    }

    public static NotifiableEnergyContainer receiverContainer(MetaMachine machine, long maxCapacity, long maxInputVoltage, long maxInputAmperage) {
        return new NotifiableEnergyContainer(machine, maxCapacity, maxInputVoltage, maxInputAmperage, 0L, 0L);
    }

    public void resetBasicInfo(long maxCapacity, long maxInputVoltage, long maxInputAmperage, long maxOutputVoltage, long maxOutputAmperage) {
        boolean isOUT;
        this.energyCapacity = maxCapacity;
        this.inputVoltage = maxInputVoltage;
        this.inputAmperage = maxInputAmperage;
        this.outputVoltage = maxOutputVoltage;
        this.outputAmperage = maxOutputAmperage;
        boolean isIN = this.inputVoltage != 0L && this.inputAmperage != 0L;
        boolean bl = isOUT = this.outputVoltage != 0L && this.outputAmperage != 0L;
        this.handlerIO = isIN && isOUT ? IO.BOTH : (isIN ? IO.IN : (isOUT ? IO.OUT : IO.NONE));
        this.checkOutputSubscription();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        this.checkOutputSubscription();
        this.updateSubs = this.getMachine().subscribeServerTick(this.updateSubs, this::updateTick);
    }

    @Override
    public void onMachineUnLoad() {
        super.onMachineUnLoad();
        if (this.updateSubs != null) {
            this.updateSubs.unsubscribe();
            this.updateSubs = null;
        }
    }

    public void checkOutputSubscription() {
        if (this.getOutputVoltage() > 0L && this.getOutputAmperage() > 0L) {
            if (this.getEnergyStored() >= this.getOutputVoltage()) {
                this.outputSubs = this.getMachine().subscribeServerTick(this.outputSubs, this::serverTick);
            } else if (this.outputSubs != null) {
                this.outputSubs.unsubscribe();
                this.outputSubs = null;
            }
        }
    }

    @Override
    public long getInputPerSec() {
        return this.lastEnergyInputPerSec;
    }

    @Override
    public long getOutputPerSec() {
        return this.lastEnergyOutputPerSec;
    }

    public void setEnergyStored(long energyStored) {
        if (this.energyStored == energyStored) {
            return;
        }
        if (energyStored > this.energyStored) {
            this.energyInputPerSec += energyStored - this.energyStored;
        } else {
            this.energyOutputPerSec += this.energyStored - energyStored;
        }
        this.energyStored = energyStored;
        this.checkOutputSubscription();
        this.notifyListeners();
    }

    public void updateTick() {
        if (this.getMachine().getOffsetTimer() % 20L == 0L) {
            this.lastEnergyOutputPerSec = this.energyOutputPerSec;
            this.lastEnergyInputPerSec = this.energyInputPerSec;
            this.energyOutputPerSec = 0L;
            this.energyInputPerSec = 0L;
        }
    }

    public void serverTick() {
        if (this.getMachine().getLevel().isClientSide) {
            return;
        }
        if (this.getEnergyStored() >= this.getOutputVoltage() && this.getOutputVoltage() > 0L && this.getOutputAmperage() > 0L) {
            long outputVoltage = this.getOutputVoltage();
            long outputAmperes = Math.min(this.getEnergyStored() / outputVoltage, this.getOutputAmperage());
            if (outputAmperes == 0L) {
                return;
            }
            long amperesUsed = 0L;
            for (Direction side : GTUtil.DIRECTIONS) {
                if (!this.outputsEnergy(side)) continue;
                Direction oppositeSide = side.getOpposite();
                IEnergyContainer energyContainer = GTCapabilityHelper.getEnergyContainer(this.machine.getLevel(), this.machine.getPos().relative(side), oppositeSide);
                if (energyContainer != null && energyContainer.inputsEnergy(oppositeSide) && (amperesUsed += energyContainer.acceptEnergyFromNetwork(oppositeSide, outputVoltage, outputAmperes - amperesUsed)) >= outputAmperes) break;
            }
            if (amperesUsed > 0L) {
                this.setEnergyStored(this.getEnergyStored() - amperesUsed * outputVoltage);
            }
        }
    }

    public boolean dischargeOrRechargeEnergyContainers(IItemHandlerModifiable itemHandler, int slotIndex, boolean simulate) {
        IEnergyStorage energyStorage;
        ItemStack stackInSlot = itemHandler.getStackInSlot(slotIndex).copy();
        if (stackInSlot.isEmpty()) {
            return false;
        }
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stackInSlot);
        if (electricItem != null) {
            if (this.handleElectricItem(electricItem, simulate)) {
                if (!simulate) {
                    itemHandler.setStackInSlot(slotIndex, stackInSlot);
                }
                return true;
            }
        } else if (ConfigHolder.INSTANCE.compat.energy.nativeEUToFE && (energyStorage = GTCapabilityHelper.getForgeEnergyItem(stackInSlot)) != null && this.handleForgeEnergyItem(energyStorage, simulate)) {
            if (!simulate) {
                itemHandler.setStackInSlot(slotIndex, stackInSlot);
            }
            return true;
        }
        return false;
    }

    private boolean handleElectricItem(IElectricItem electricItem, boolean simulate) {
        byte machineTier = GTUtil.getTierByVoltage(Math.max(this.getInputVoltage(), this.getOutputVoltage()));
        int chargeTier = Math.min(machineTier, electricItem.getTier());
        double chargePercent = (double)this.getEnergyStored() / ((double)this.getEnergyCapacity() * 1.0);
        if (electricItem.canProvideChargeExternally() && this.getEnergyCanBeInserted() > 0L && chargePercent <= 0.33 && chargeTier == machineTier) {
            long dischargedBy = electricItem.discharge(this.getEnergyCanBeInserted(), machineTier, false, true, simulate);
            if (!simulate) {
                this.addEnergy(dischargedBy);
            }
            return dischargedBy > 0L;
        }
        if (chargePercent > 0.66) {
            long chargedBy = electricItem.charge(this.getEnergyStored(), chargeTier, false, false);
            if (!simulate) {
                this.removeEnergy(chargedBy);
            }
            return chargedBy > 0L;
        }
        return false;
    }

    private boolean handleForgeEnergyItem(IEnergyStorage energyStorage, boolean simulate) {
        byte machineTier = GTUtil.getTierByVoltage(Math.max(this.getInputVoltage(), this.getOutputVoltage()));
        double chargePercent = (double)this.getEnergyStored() / ((double)this.getEnergyCapacity() * 1.0);
        if (chargePercent > 0.66) {
            long chargedBy = FeCompat.insertEu(energyStorage, GTValues.V[machineTier], simulate);
            if (!simulate) {
                this.removeEnergy(chargedBy);
            }
            return chargedBy > 0L;
        }
        return false;
    }

    @Override
    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        long latestTimeStamp = this.getMachine().getOffsetTimer();
        if (this.lastTimeStamp < latestTimeStamp) {
            this.amps = 0L;
            this.lastTimeStamp = latestTimeStamp;
        }
        if (this.amps >= this.getInputAmperage()) {
            return 0L;
        }
        long canAccept = this.getEnergyCapacity() - this.getEnergyStored();
        if (voltage > 0L && (side == null || this.inputsEnergy(side))) {
            long amperesAccepted;
            MetaMachine metaMachine;
            if (voltage > this.getInputVoltage() && (metaMachine = this.machine) instanceof IExplosionMachine) {
                IExplosionMachine explosionMachine = (IExplosionMachine)((Object)metaMachine);
                explosionMachine.doExplosion(GTUtil.getExplosionPower(voltage));
                return Math.min(amperage, this.getInputAmperage() - this.amps);
            }
            if (canAccept >= voltage && (amperesAccepted = Math.min(canAccept / voltage, Math.min(amperage, this.getInputAmperage() - this.amps))) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + voltage * amperesAccepted);
                this.amps += amperesAccepted;
                return amperesAccepted;
            }
        }
        return 0L;
    }

    @Override
    public boolean inputsEnergy(Direction side) {
        return !this.outputsEnergy(side) && this.getInputVoltage() > 0L && (this.sideInputCondition == null || this.sideInputCondition.test(side));
    }

    @Override
    public boolean outputsEnergy(Direction side) {
        return this.getOutputVoltage() > 0L && (this.sideOutputCondition == null || this.sideOutputCondition.test(side));
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        long newEnergyStored;
        long oldEnergyStored = this.getEnergyStored();
        long l = newEnergyStored = this.energyCapacity - oldEnergyStored < energyToAdd ? this.energyCapacity : oldEnergyStored + energyToAdd;
        if (newEnergyStored < 0L) {
            newEnergyStored = 0L;
        }
        this.setEnergyStored(newEnergyStored);
        return newEnergyStored - oldEnergyStored;
    }

    @Override
    public List<EnergyStack> handleRecipeInner(IO io, GTRecipe recipe, List<EnergyStack> left, boolean simulate) {
        ListIterator<EnergyStack> it = left.listIterator();
        while (it.hasNext()) {
            EnergyStack stack = it.next();
            if (stack.isEmpty()) {
                it.remove();
                continue;
            }
            long totalEU = stack.getTotalEU();
            long canTransfer = Math.min(totalEU, io == IO.IN ? this.getEnergyStored() : this.getEnergyCapacity() - this.getEnergyStored());
            if (!simulate) {
                this.changeEnergy(io == IO.IN ? -canTransfer : canTransfer);
            }
            if ((totalEU -= canTransfer) <= 0L) {
                it.remove();
                continue;
            }
            it.set(new EnergyStack(totalEU));
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    @NotNull
    public List<Object> getContents() {
        long amperage = Math.max(this.getInputAmperage(), this.getOutputAmperage());
        return Collections.singletonList(EnergyContainerList.calculateVoltageAmperage(this.getEnergyStored(), amperage));
    }

    @Override
    public double getTotalContentAmount() {
        return this.energyStored;
    }

    @Override
    public RecipeCapability<EnergyStack> getCapability() {
        return EURecipeCapability.CAP;
    }

    @Override
    @Generated
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    @Generated
    public long getEnergyStored() {
        return this.energyStored;
    }

    @Override
    @Generated
    public long getEnergyCapacity() {
        return this.energyCapacity;
    }

    @Override
    @Generated
    public long getInputVoltage() {
        return this.inputVoltage;
    }

    @Override
    @Generated
    public long getInputAmperage() {
        return this.inputAmperage;
    }

    @Override
    @Generated
    public long getOutputVoltage() {
        return this.outputVoltage;
    }

    @Override
    @Generated
    public long getOutputAmperage() {
        return this.outputAmperage;
    }

    @Generated
    public void setSideInputCondition(Predicate<Direction> sideInputCondition) {
        this.sideInputCondition = sideInputCondition;
    }

    @Generated
    public void setSideOutputCondition(Predicate<Direction> sideOutputCondition) {
        this.sideOutputCondition = sideOutputCondition;
    }
}

