/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.virtualregistry;

import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public abstract class VirtualEntry
implements INBTSerializable<CompoundTag>,
ITagSerializable<CompoundTag> {
    public static final String DEFAULT_COLOR = "FFFFFFFF";
    protected static final String COLOR_KEY = "color";
    protected static final String DESC_KEY = "description";
    @NotNull
    private String description = "";
    private int color = -1;
    private String colorStr = "FFFFFFFF";

    public abstract EntryTypes<? extends VirtualEntry> getType();

    public void setColor(String color) {
        this.color = VirtualEntry.parseColor(color);
        this.colorStr = color.toUpperCase(Locale.ROOT);
    }

    public void setColor(int color) {
        this.color = color;
        this.colorStr = Integer.toHexString(color).toUpperCase(Locale.ROOT);
    }

    public static int parseColor(String colorString) {
        if (colorString.length() < 8) {
            throw new IllegalArgumentException("Invalid color string: " + colorString);
        }
        int red = Integer.parseInt(colorString.substring(0, 2), 16);
        int green = Integer.parseInt(colorString.substring(2, 4), 16);
        int blue = Integer.parseInt(colorString.substring(4, 6), 16);
        int alpha = Integer.parseInt(colorString.substring(6, 8), 16);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VirtualEntry)) {
            return false;
        }
        VirtualEntry other = (VirtualEntry)o;
        return this.getType() == other.getType() && this.color == other.color && this.description.equals(other.description);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString(COLOR_KEY, this.colorStr);
        if (!this.description.isEmpty()) {
            tag.putString(DESC_KEY, this.description);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setColor(nbt.getString(COLOR_KEY));
        if (nbt.contains(DESC_KEY)) {
            this.description = nbt.getString(DESC_KEY);
        }
    }

    public boolean canRemove() {
        return this.description.isEmpty();
    }

    @NotNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public String getColorStr() {
        return this.colorStr;
    }

    @NotNull
    @Generated
    public VirtualEntry setDescription(@NotNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
        return this;
    }
}

