/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.virtualregistry.entries;

import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEntry;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VirtualItemStorage
extends VirtualEntry {
    protected static final int DEFAULT_SLOT_AMOUNT = 1;
    @NotNull
    private final CustomItemStackHandler handler;
    protected static final String ITEM_KEY = "items";

    public VirtualItemStorage() {
        this(1);
    }

    public VirtualItemStorage(int slots) {
        this.handler = new CustomItemStackHandler(slots);
    }

    @Override
    public EntryTypes<? extends VirtualEntry> getType() {
        return EntryTypes.ENDER_ITEM;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VirtualItemStorage)) {
            return false;
        }
        VirtualItemStorage other = (VirtualItemStorage)o;
        return other.handler == this.handler;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.put(ITEM_KEY, (Tag)this.handler.serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.handler.deserializeNBT(nbt.getCompound(ITEM_KEY));
    }

    @Override
    public boolean canRemove() {
        return super.canRemove() && this.isEmpty();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Generated
    public CustomItemStackHandler getHandler() {
        return this.handler;
    }
}

