/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.error.SinglePredicateError;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.pattern.util.PatternMatchContext;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPattern {
    static Direction[] FACINGS = new Direction[]{Direction.SOUTH, Direction.NORTH, Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN};
    static Direction[] FACINGS_H = new Direction[]{Direction.SOUTH, Direction.NORTH, Direction.WEST, Direction.EAST};
    public final int[][] aisleRepetitions;
    public final RelativeDirection[] structureDir;
    protected final TraceabilityPredicate[][][] blockMatches;
    protected final int fingerLength;
    protected final int thumbLength;
    protected final int palmLength;
    protected final int[] centerOffset;
    protected int[] formedRepetitionCount;

    public BlockPattern(TraceabilityPredicate[][][] predicatesIn, RelativeDirection[] structureDir, int[][] aisleRepetitions, int[] centerOffset) {
        this.blockMatches = predicatesIn;
        this.fingerLength = predicatesIn.length;
        this.structureDir = structureDir;
        this.aisleRepetitions = aisleRepetitions;
        this.formedRepetitionCount = new int[aisleRepetitions.length];
        if (this.fingerLength > 0) {
            this.thumbLength = predicatesIn[0].length;
            this.palmLength = this.thumbLength > 0 ? predicatesIn[0][0].length : 0;
        } else {
            this.thumbLength = 0;
            this.palmLength = 0;
        }
        this.centerOffset = centerOffset;
    }

    public boolean checkPatternAt(MultiblockState worldState, boolean savePredicate) {
        Direction[] directionArray;
        IMultiController controller = worldState.getController();
        if (controller == null) {
            worldState.setError(new PatternStringError("no controller found"));
            return false;
        }
        BlockPos centerPos = controller.self().getPos();
        Direction frontFacing = controller.self().getFrontFacing();
        if (controller.hasFrontFacing()) {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = frontFacing;
        } else {
            Direction[] directionArray3 = new Direction[4];
            directionArray3[0] = Direction.SOUTH;
            directionArray3[1] = Direction.NORTH;
            directionArray3[2] = Direction.EAST;
            directionArray = directionArray3;
            directionArray3[3] = Direction.WEST;
        }
        Direction[] facings = directionArray;
        Direction upwardsFacing = controller.self().getUpwardsFacing();
        boolean allowsFlip = controller.self().allowFlip();
        for (Direction direction : facings) {
            boolean result = this.checkPatternAt(worldState, centerPos, direction, upwardsFacing, false, savePredicate);
            if (result) {
                return true;
            }
            if (!allowsFlip) continue;
            return this.checkPatternAt(worldState, centerPos, direction, upwardsFacing, true, savePredicate);
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="7.0")
    public int[] getDimensions() {
        return new int[]{this.fingerLength, this.thumbLength, this.palmLength};
    }

    public boolean checkPatternAt(MultiblockState worldState, BlockPos centerPos, Direction frontFacing, Direction upwardsFacing, boolean isFlipped, boolean savePredicate) {
        boolean findFirstAisle = false;
        int minZ = -this.centerOffset[4];
        worldState.clean();
        PatternMatchContext matchContext = worldState.getMatchContext();
        Object2IntOpenHashMap<SimplePredicate> globalCount = worldState.getGlobalCount();
        Object2IntOpenHashMap<SimplePredicate> layerCount = worldState.getLayerCount();
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            int validRepetitions = 0;
            int r = 0;
            while (findFirstAisle ? r < this.aisleRepetitions[c][1] : z <= -this.centerOffset[3]) {
                block20: {
                    layerCount.clear();
                    int b = 0;
                    int y = -this.centerOffset[1];
                    while (b < this.thumbLength) {
                        int a = 0;
                        int x = -this.centerOffset[0];
                        while (a < this.palmLength) {
                            IMachineBlockEntity machineBlockEntity;
                            worldState.setError(null);
                            TraceabilityPredicate predicate = this.blockMatches[c][b][a];
                            BlockPos pos = this.setActualRelativeOffset(x, y, z, frontFacing, upwardsFacing, isFlipped).offset(centerPos.getX(), centerPos.getY(), centerPos.getZ());
                            if (!worldState.update(pos, predicate)) {
                                return false;
                            }
                            if (predicate.addCache()) {
                                worldState.addPosCache(pos);
                                if (savePredicate) {
                                    matchContext.getOrCreate("predicates", HashMap::new).put(pos, predicate);
                                }
                            }
                            boolean canPartShared = true;
                            Object object = worldState.getTileEntity();
                            if (object instanceof IMachineBlockEntity && (object = (machineBlockEntity = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiPart) {
                                IMultiPart part = (IMultiPart)object;
                                if (!predicate.isAny()) {
                                    if (part.isFormed() && !part.canShared() && !part.hasController(worldState.controllerPos)) {
                                        canPartShared = false;
                                        worldState.setError(new PatternStringError("multiblocked.pattern.error.share"));
                                    } else {
                                        matchContext.getOrCreate("parts", HashSet::new).add(part);
                                    }
                                }
                            }
                            if (worldState.getBlockState().getBlock() instanceof ActiveBlock) {
                                matchContext.getOrCreate("vaBlocks", LongOpenHashSet::new).add(worldState.getPos().asLong());
                            }
                            if (!predicate.test(worldState) || !canPartShared) {
                                if (findFirstAisle) {
                                    if (r < this.aisleRepetitions[c][0]) {
                                        c = 0;
                                        r = 0;
                                        z = minZ++;
                                        matchContext.reset();
                                        findFirstAisle = false;
                                    }
                                } else {
                                    ++z;
                                }
                                break block20;
                            }
                            matchContext.getOrCreate("ioMap", Long2ObjectOpenHashMap::new).put(worldState.getPos().asLong(), (Object)worldState.io);
                            ++a;
                            ++x;
                        }
                        ++b;
                        ++y;
                    }
                    findFirstAisle = true;
                    ++z;
                    for (Object2IntMap.Entry entry : layerCount.object2IntEntrySet()) {
                        if (entry.getIntValue() >= ((SimplePredicate)entry.getKey()).minLayerCount) continue;
                        worldState.setError(new SinglePredicateError((SimplePredicate)entry.getKey(), 3));
                        return false;
                    }
                    ++validRepetitions;
                }
                ++r;
            }
            if (r < this.aisleRepetitions[c][0] || worldState.hasError() || !findFirstAisle) {
                if (!worldState.hasError()) {
                    worldState.setError(new PatternError());
                }
                return false;
            }
            this.formedRepetitionCount[c] = validRepetitions;
        }
        for (Object2IntMap.Entry entry : globalCount.object2IntEntrySet()) {
            if (entry.getIntValue() >= ((SimplePredicate)entry.getKey()).minCount) continue;
            worldState.setError(new SinglePredicateError((SimplePredicate)entry.getKey(), 1));
            return false;
        }
        worldState.setError(null);
        worldState.setNeededFlip(isFlipped);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void autoBuild(Player player, MultiblockState worldState) {
        Level world = player.level();
        int minZ = -this.centerOffset[4];
        worldState.clean();
        IMultiController controller = worldState.getController();
        BlockPos centerPos = controller.self().getPos();
        Direction facing = controller.self().getFrontFacing();
        Direction upwardsFacing = controller.self().getUpwardsFacing();
        boolean isFlipped = controller.self().isFlipped();
        Object2IntOpenHashMap<SimplePredicate> cacheGlobal = worldState.getGlobalCount();
        Object2IntOpenHashMap<SimplePredicate> cacheLayer = worldState.getLayerCount();
        HashMap<BlockPos, Object> blocks = new HashMap<BlockPos, Object>();
        HashSet<BlockPos> placeBlockPos = new HashSet<BlockPos>();
        blocks.put(centerPos, controller);
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            for (int r = 0; r < this.aisleRepetitions[c][0]; ++r) {
                cacheLayer.clear();
                int b = 0;
                int y = -this.centerOffset[1];
                while (b < this.thumbLength) {
                    int a = 0;
                    int x = -this.centerOffset[0];
                    while (a < this.palmLength) {
                        TraceabilityPredicate predicate = this.blockMatches[c][b][a];
                        BlockPos pos2 = this.setActualRelativeOffset(x, y, z, facing, upwardsFacing, isFlipped).offset(centerPos.getX(), centerPos.getY(), centerPos.getZ());
                        worldState.update(pos2, predicate);
                        if (!world.isEmptyBlock(pos2)) {
                            blocks.put(pos2, world.getBlockState(pos2));
                            for (SimplePredicate limit : predicate.limited) {
                                limit.testLimited(worldState);
                            }
                        } else {
                            void var26_28;
                            int curr;
                            boolean find = false;
                            Object[] infos = new BlockInfo[]{};
                            for (SimplePredicate simplePredicate : predicate.limited) {
                                if (simplePredicate.minLayerCount <= 0 || (curr = cacheLayer.getInt((Object)simplePredicate)) >= simplePredicate.minLayerCount || simplePredicate.maxLayerCount != -1 && curr >= simplePredicate.maxLayerCount) continue;
                                cacheLayer.addTo((Object)simplePredicate, 1);
                                infos = simplePredicate.candidates == null ? null : simplePredicate.candidates.get();
                                find = true;
                                break;
                            }
                            if (!find) {
                                for (SimplePredicate simplePredicate : predicate.limited) {
                                    if (simplePredicate.minCount <= 0 || (curr = cacheGlobal.getInt((Object)simplePredicate)) >= simplePredicate.minCount || simplePredicate.maxCount != -1 && curr >= simplePredicate.maxCount) continue;
                                    cacheGlobal.addTo((Object)simplePredicate, 1);
                                    infos = simplePredicate.candidates == null ? null : simplePredicate.candidates.get();
                                    find = true;
                                    break;
                                }
                            }
                            if (!find) {
                                for (SimplePredicate simplePredicate : predicate.limited) {
                                    if (simplePredicate.maxLayerCount != -1 && cacheLayer.getOrDefault((Object)simplePredicate, Integer.MAX_VALUE) == simplePredicate.maxLayerCount || simplePredicate.maxCount != -1 && cacheGlobal.getOrDefault((Object)simplePredicate, Integer.MAX_VALUE) == simplePredicate.maxCount) continue;
                                    cacheLayer.addTo((Object)simplePredicate, 1);
                                    cacheGlobal.addTo((Object)simplePredicate, 1);
                                    infos = (BlockInfo[])ArrayUtils.addAll((Object[])infos, simplePredicate.candidates == null ? null : simplePredicate.candidates.get());
                                }
                                for (SimplePredicate simplePredicate : predicate.common) {
                                    infos = (BlockInfo[])ArrayUtils.addAll((Object[])infos, simplePredicate.candidates == null ? null : simplePredicate.candidates.get());
                                }
                            }
                            ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
                            if (infos != null) {
                                Object[] objectArray = infos;
                                curr = objectArray.length;
                                for (int i = 0; i < curr; ++i) {
                                    BlockInfo info = objectArray[i];
                                    if (info.getBlockState().getBlock() == Blocks.AIR) continue;
                                    candidates.add(info.getItemStackForm());
                                }
                            }
                            Object var26_39 = null;
                            int foundSlot = -1;
                            IItemHandler handler = null;
                            if (!player.isCreative()) {
                                foundHandler = BlockPattern.getMatchStackWithHandler(candidates, (LazyOptional<IItemHandler>)player.getCapability(ForgeCapabilities.ITEM_HANDLER));
                                if (foundHandler != null) {
                                    foundSlot = foundHandler.firstInt();
                                    handler = (IItemHandler)foundHandler.second();
                                    ItemStack itemStack = handler.getStackInSlot(foundSlot).copy();
                                }
                            } else {
                                ItemStack candidate;
                                ItemStack itemStack;
                                foundHandler = candidates.iterator();
                                while (foundHandler.hasNext() && ((itemStack = (candidate = (ItemStack)foundHandler.next()).copy()).isEmpty() || !(itemStack.getItem() instanceof BlockItem))) {
                                    Object var26_44 = null;
                                }
                            }
                            if (var26_28 != null) {
                                BlockEntity blockEntity;
                                BlockPlaceContext context;
                                BlockItem itemBlock = (BlockItem)var26_28.getItem();
                                InteractionResult interactionResult = itemBlock.place(context = new BlockPlaceContext(world, player, InteractionHand.MAIN_HAND, (ItemStack)var26_28, BlockHitResult.miss((Vec3)player.getEyePosition(0.0f), (Direction)Direction.UP, (BlockPos)pos2)));
                                if (interactionResult != InteractionResult.FAIL) {
                                    placeBlockPos.add(pos2);
                                    if (handler != null) {
                                        handler.extractItem(foundSlot, 1, false);
                                    }
                                }
                                if ((blockEntity = world.getBlockEntity(pos2)) instanceof IMachineBlockEntity) {
                                    IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)blockEntity;
                                    blocks.put(pos2, machineBlockEntity.getMetaMachine());
                                } else {
                                    blocks.put(pos2, world.getBlockState(pos2));
                                }
                            }
                        }
                        ++a;
                        ++x;
                    }
                    ++b;
                    ++y;
                }
                ++z;
            }
        }
        Direction frontFacing = controller.self().getFrontFacing();
        blocks.forEach((pos, block) -> {
            if (!(block instanceof IMultiController)) {
                if (block instanceof BlockState && placeBlockPos.contains(pos)) {
                    this.resetFacing((BlockPos)pos, (BlockState)block, frontFacing, (p, f) -> {
                        Object object = blocks.get(p.relative(f));
                        return object == null || object instanceof BlockState && ((BlockState)object).getBlock() == Blocks.AIR;
                    }, state -> world.setBlock(pos, state, 3));
                } else if (block instanceof MetaMachine) {
                    MetaMachine machine = (MetaMachine)block;
                    this.resetFacing((BlockPos)pos, machine.getBlockState(), frontFacing, (p, f) -> {
                        BlockState blockState;
                        Object object = blocks.get(p.relative(f));
                        if (object == null || object instanceof BlockState && (blockState = (BlockState)object).isAir()) {
                            return machine.isFacingValid((Direction)f);
                        }
                        return false;
                    }, state -> world.setBlock(pos, state, 3));
                }
            }
        });
    }

    public BlockInfo[][][] getPreview(int[] repetition) {
        Object2IntOpenHashMap cacheGlobal = new Object2IntOpenHashMap();
        HashMap<BlockPos, BlockInfo> blocks = new HashMap<BlockPos, BlockInfo>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int x = 0;
        for (int l = 0; l < this.fingerLength; ++l) {
            for (int r = 0; r < repetition[l]; ++r) {
                Object2IntOpenHashMap cacheLayer = new Object2IntOpenHashMap();
                for (int y = 0; y < this.thumbLength; ++y) {
                    for (int z = 0; z < this.palmLength; ++z) {
                        TraceabilityPredicate predicate = this.blockMatches[l][y][z];
                        boolean find = false;
                        BlockInfo[] infos = null;
                        for (SimplePredicate limit : predicate.limited) {
                            if (limit.minLayerCount <= 0 || cacheLayer.getInt((Object)limit) >= limit.minLayerCount) continue;
                            cacheLayer.addTo((Object)limit, 1);
                            if (cacheGlobal.getInt((Object)limit) >= limit.previewCount) continue;
                            cacheGlobal.addTo((Object)limit, 1);
                            infos = limit.candidates == null ? null : limit.candidates.get();
                            find = true;
                            break;
                        }
                        if (!find) {
                            for (SimplePredicate limit : predicate.limited) {
                                if (limit.minCount == -1 && limit.previewCount == -1) continue;
                                if (cacheGlobal.getInt((Object)limit) < limit.previewCount) {
                                    cacheGlobal.addTo((Object)limit, 1);
                                } else {
                                    if (limit.minCount <= 0 || cacheGlobal.getInt((Object)limit) >= limit.minCount) continue;
                                    cacheGlobal.addTo((Object)limit, 1);
                                }
                                infos = limit.candidates == null ? null : limit.candidates.get();
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (SimplePredicate common : predicate.common) {
                                if (common.previewCount <= 0 || cacheGlobal.getInt((Object)common) >= common.previewCount) continue;
                                cacheGlobal.addTo((Object)common, 1);
                                infos = common.candidates == null ? null : common.candidates.get();
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (SimplePredicate common : predicate.common) {
                                if (common.previewCount != -1) continue;
                                infos = common.candidates == null ? null : common.candidates.get();
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (SimplePredicate limit : predicate.limited) {
                                if (limit.previewCount != -1) continue;
                                if (limit.maxCount != -1 || limit.maxLayerCount != -1) {
                                    if (cacheGlobal.getOrDefault((Object)limit, 0) < limit.maxCount) {
                                        cacheGlobal.addTo((Object)limit, 1);
                                    } else {
                                        if (cacheLayer.getOrDefault((Object)limit, 0) >= limit.maxLayerCount) continue;
                                        cacheLayer.addTo((Object)limit, 1);
                                    }
                                }
                                infos = limit.candidates == null ? null : limit.candidates.get();
                                break;
                            }
                        }
                        BlockInfo info2 = infos == null || infos.length == 0 ? BlockInfo.EMPTY : infos[0];
                        BlockPos pos2 = this.setActualRelativeOffset(z, y, x, Direction.NORTH, Direction.UP, false);
                        blocks.put(pos2, info2);
                        minX = Math.min(pos2.getX(), minX);
                        minY = Math.min(pos2.getY(), minY);
                        minZ = Math.min(pos2.getZ(), minZ);
                        maxX = Math.max(pos2.getX(), maxX);
                        maxY = Math.max(pos2.getY(), maxY);
                        maxZ = Math.max(pos2.getZ(), maxZ);
                    }
                }
                ++x;
            }
        }
        BlockInfo[][][] result = (BlockInfo[][][])Array.newInstance(BlockInfo.class, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        int finalMinX = minX;
        int finalMinY = minY;
        int finalMinZ = minZ;
        blocks.forEach((pos, info) -> {
            this.resetFacing((BlockPos)pos, info.getBlockState(), null, (p, f) -> {
                BlockInfo blockInfo = (BlockInfo)blocks.get(p.relative(f));
                if (blockInfo == null || blockInfo.getBlockState().getBlock() == Blocks.AIR) {
                    MetaMachineBlock machineBlock;
                    BlockEntity patt26862$temp;
                    Block patt26681$temp = ((BlockInfo)blocks.get(pos)).getBlockState().getBlock();
                    if (patt26681$temp instanceof MetaMachineBlock && (patt26862$temp = (machineBlock = (MetaMachineBlock)patt26681$temp).newBlockEntity(BlockPos.ZERO, machineBlock.defaultBlockState())) instanceof IMachineBlockEntity) {
                        IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)patt26862$temp;
                        MetaMachine machine = machineBlockEntity.getMetaMachine();
                        if (machine instanceof IMultiController) {
                            return false;
                        }
                        return machine.isFacingValid((Direction)f);
                    }
                    return true;
                }
                return false;
            }, arg_0 -> ((BlockInfo)info).setBlockState(arg_0));
            result[pos.getX() - finalMinX][pos.getY() - finalMinY][pos.getZ() - finalMinZ] = info;
        });
        return result;
    }

    private void resetFacing(BlockPos pos, BlockState blockState, Direction facing, BiPredicate<BlockPos, Direction> checker, Consumer<BlockState> consumer) {
        if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
            this.tryFacings(blockState, pos, checker, consumer, (Property<Direction>)BlockStateProperties.FACING, facing == null ? FACINGS : (Direction[])ArrayUtils.addAll((Object[])new Direction[]{facing}, (Object[])FACINGS));
        } else if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            this.tryFacings(blockState, pos, checker, consumer, (Property<Direction>)BlockStateProperties.HORIZONTAL_FACING, facing == null || facing.getAxis() == Direction.Axis.Y ? FACINGS_H : (Direction[])ArrayUtils.addAll((Object[])new Direction[]{facing}, (Object[])FACINGS_H));
        }
    }

    private void tryFacings(BlockState blockState, BlockPos pos, BiPredicate<BlockPos, Direction> checker, Consumer<BlockState> consumer, Property<Direction> property, Direction[] facings) {
        Direction found = null;
        for (Direction facing : facings) {
            if (!checker.test(pos, facing)) continue;
            found = facing;
            break;
        }
        if (found == null) {
            found = Direction.NORTH;
        }
        consumer.accept((BlockState)blockState.setValue(property, (Comparable)found));
    }

    private BlockPos setActualRelativeOffset(int x, int y, int z, Direction facing, Direction upwardsFacing, boolean isFlipped) {
        int[] c0 = new int[]{x, y, z};
        int[] c1 = new int[3];
        if (facing == Direction.UP || facing == Direction.DOWN) {
            Direction of = facing == Direction.DOWN ? upwardsFacing : upwardsFacing.getOpposite();
            block16: for (int i = 0; i < 3; ++i) {
                switch (this.structureDir[i].getActualDirection(of)) {
                    case UP: {
                        c1[1] = c0[i];
                        continue block16;
                    }
                    case DOWN: {
                        c1[1] = -c0[i];
                        continue block16;
                    }
                    case WEST: {
                        c1[0] = -c0[i];
                        continue block16;
                    }
                    case EAST: {
                        c1[0] = c0[i];
                        continue block16;
                    }
                    case NORTH: {
                        c1[2] = -c0[i];
                        continue block16;
                    }
                    case SOUTH: {
                        c1[2] = c0[i];
                    }
                }
            }
            int xOffset = upwardsFacing.getStepX();
            int zOffset = upwardsFacing.getStepZ();
            if (xOffset == 0) {
                int tmp = c1[2];
                c1[2] = zOffset > 0 ? c1[1] : -c1[1];
                c1[1] = zOffset > 0 ? -tmp : tmp;
            } else {
                int tmp = c1[0];
                c1[0] = xOffset > 0 ? c1[1] : -c1[1];
                int n = c1[1] = xOffset > 0 ? -tmp : tmp;
            }
            if (isFlipped) {
                if (upwardsFacing == Direction.NORTH || upwardsFacing == Direction.SOUTH) {
                    c1[0] = -c1[0];
                } else {
                    c1[2] = -c1[2];
                }
            }
        } else {
            block17: for (int i = 0; i < 3; ++i) {
                switch (this.structureDir[i].getActualDirection(facing)) {
                    case UP: {
                        c1[1] = c0[i];
                        continue block17;
                    }
                    case DOWN: {
                        c1[1] = -c0[i];
                        continue block17;
                    }
                    case WEST: {
                        c1[0] = -c0[i];
                        continue block17;
                    }
                    case EAST: {
                        c1[0] = c0[i];
                        continue block17;
                    }
                    case NORTH: {
                        c1[2] = -c0[i];
                        continue block17;
                    }
                    case SOUTH: {
                        c1[2] = c0[i];
                    }
                }
            }
            if (upwardsFacing == Direction.WEST || upwardsFacing == Direction.EAST) {
                int zOffset;
                int xOffset = upwardsFacing == Direction.EAST ? facing.getClockWise().getStepX() : facing.getClockWise().getOpposite().getStepX();
                int n = zOffset = upwardsFacing == Direction.EAST ? facing.getClockWise().getStepZ() : facing.getClockWise().getOpposite().getStepZ();
                if (xOffset == 0) {
                    int tmp = c1[2];
                    c1[2] = zOffset > 0 ? -c1[1] : c1[1];
                    c1[1] = zOffset > 0 ? tmp : -tmp;
                } else {
                    int tmp = c1[0];
                    c1[0] = xOffset > 0 ? -c1[1] : c1[1];
                    c1[1] = xOffset > 0 ? tmp : -tmp;
                }
            } else if (upwardsFacing == Direction.SOUTH) {
                c1[1] = -c1[1];
                if (facing.getStepX() == 0) {
                    c1[0] = -c1[0];
                } else {
                    c1[2] = -c1[2];
                }
            }
            if (isFlipped) {
                if (upwardsFacing == Direction.NORTH || upwardsFacing == Direction.SOUTH) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        c1[0] = -c1[0];
                    } else {
                        c1[2] = -c1[2];
                    }
                } else {
                    c1[1] = -c1[1];
                }
            }
        }
        return new BlockPos(c1[0], c1[1], c1[2]);
    }

    @Nullable
    private static IntObjectPair<IItemHandler> getMatchStackWithHandler(List<ItemStack> candidates, LazyOptional<IItemHandler> cap) {
        IItemHandler handler = cap.resolve().orElse(null);
        if (handler == null) {
            return null;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            @NotNull ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            @NotNull LazyOptional stackCap = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (stackCap.isPresent()) {
                IntObjectPair<IItemHandler> rt = BlockPattern.getMatchStackWithHandler(candidates, (LazyOptional<IItemHandler>)stackCap);
                if (rt == null) continue;
                return rt;
            }
            if (!candidates.stream().anyMatch(candidate -> GTUtil.isSameItemSameTags(candidate, stack)) || stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) continue;
            return IntObjectPair.of((int)i, (Object)handler);
        }
        return null;
    }

    @Generated
    public int[] getFormedRepetitionCount() {
        return this.formedRepetitionCount;
    }
}

