/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern.error;

import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PatternError {
    protected MultiblockState worldState;

    public void setWorldState(MultiblockState worldState) {
        this.worldState = worldState;
    }

    public Level getWorld() {
        return this.worldState.getWorld();
    }

    public BlockPos getPos() {
        return this.worldState.getPos();
    }

    public List<List<ItemStack>> getCandidates() {
        TraceabilityPredicate predicate = this.worldState.predicate;
        ArrayList<List<ItemStack>> candidates = new ArrayList<List<ItemStack>>();
        for (SimplePredicate common : predicate.common) {
            candidates.add(common.getCandidates());
        }
        for (SimplePredicate limited : predicate.limited) {
            candidates.add(limited.getCandidates());
        }
        return candidates;
    }

    public Component getErrorInfo() {
        List<List<ItemStack>> candidates = this.getCandidates();
        StringBuilder builder = new StringBuilder();
        for (List<ItemStack> candidate : candidates) {
            if (candidate.isEmpty()) continue;
            builder.append(candidate.get(0).getDisplayName());
            builder.append(", ");
        }
        builder.append("...");
        return Component.translatable((String)"gtceu.multiblock.pattern.error", (Object[])new Object[]{builder.toString(), this.worldState.getPos()});
    }
}

