/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDNetworkPart;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistanceNetwork;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeType;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class LongDistancePipeBlock
extends Block
implements ILDNetworkPart {
    private final LongDistancePipeType pipeType;

    public LongDistancePipeBlock(BlockBehaviour.Properties properties, LongDistancePipeType pipeType) {
        super(properties);
        this.pipeType = pipeType;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide) {
            return;
        }
        List<LongDistanceNetwork> networks = this.findNetworks(level, pos);
        if (networks.isEmpty()) {
            LongDistanceNetwork network = this.pipeType.createNetwork(level);
            network.onPlacePipe(pos);
        } else if (networks.size() == 1) {
            networks.get(0).onPlacePipe(pos);
        } else {
            LongDistanceNetwork main = networks.get(0);
            main.onPlacePipe(pos);
            networks.remove(0);
            for (LongDistanceNetwork network : networks) {
                main.mergePipeNet(network);
            }
        }
    }

    public List<LongDistanceNetwork> findNetworks(Level level, BlockPos pos) {
        ArrayList<LongDistanceNetwork> networks = new ArrayList<LongDistanceNetwork>();
        BlockPos.MutableBlockPos offsetPos = new BlockPos.MutableBlockPos();
        for (Direction facing : GTUtil.DIRECTIONS) {
            ILDEndpoint endpoint;
            offsetPos.set((Vec3i)pos).move(facing);
            LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)level, (BlockPos)offsetPos);
            if (network == null || this.pipeType != network.getPipeType() || (endpoint = ILDEndpoint.tryGet((LevelAccessor)level, (BlockPos)offsetPos)) != null && endpoint.getFrontFacing().getAxis() != facing.getAxis()) continue;
            networks.add(network);
        }
        return networks;
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        super.destroy(level, pos, state);
        if (level.isClientSide()) {
            return;
        }
        LongDistanceNetwork network = LongDistanceNetwork.get(level, pos);
        if (network != null) {
            network.onRemovePipe(pos);
        }
    }

    @Override
    @Generated
    public LongDistancePipeType getPipeType() {
        return this.pipeType;
    }
}

