/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroup;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupColor;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupDistinctness;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.ActionResult;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.RecipeRunner;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeHelper {
    public static EnergyStack getRealEUt(@NotNull GTRecipe recipe) {
        EnergyStack stack = recipe.getInputEUt();
        if (!stack.isEmpty()) {
            return stack;
        }
        return recipe.getOutputEUt();
    }

    public static EnergyStack.WithIO getRealEUtWithIO(@NotNull GTRecipe recipe) {
        EnergyStack stack = recipe.getInputEUt();
        if (!stack.isEmpty()) {
            return new EnergyStack.WithIO(stack, IO.IN);
        }
        return new EnergyStack.WithIO(recipe.getOutputEUt(), IO.OUT);
    }

    public static int getRecipeEUtTier(GTRecipe recipe) {
        EnergyStack stack = RecipeHelper.getRealEUt(recipe);
        long EUt = stack.voltage();
        if (recipe.parallels > 1) {
            EUt /= (long)recipe.parallels;
        }
        return GTUtil.getTierByVoltage(EUt);
    }

    public static int getPreOCRecipeEuTier(GTRecipe recipe) {
        EnergyStack stack = RecipeHelper.getRealEUt(recipe);
        long EUt = stack.getTotalEU();
        if (recipe.parallels > 1) {
            EUt /= (long)recipe.parallels;
        }
        return GTUtil.getTierByVoltage(EUt >>= recipe.ocLevel * 2);
    }

    public static <T> List<T> getInputContents(GTRecipeBuilder builder, RecipeCapability<T> capability) {
        return builder.input.getOrDefault(capability, Collections.emptyList()).stream().map(content -> capability.of(content.getContent())).collect(Collectors.toList());
    }

    public static <T> List<T> getInputContents(GTRecipe recipe, RecipeCapability<T> capability) {
        return recipe.getInputContents(capability).stream().map(content -> capability.of(content.getContent())).collect(Collectors.toList());
    }

    public static <T> List<T> getOutputContents(GTRecipeBuilder builder, RecipeCapability<T> capability) {
        return builder.output.getOrDefault(capability, Collections.emptyList()).stream().map(content -> capability.of(content.getContent())).collect(Collectors.toList());
    }

    public static <T> List<T> getOutputContents(GTRecipe recipe, RecipeCapability<T> capability) {
        return recipe.getOutputContents(capability).stream().map(content -> capability.of(content.getContent())).collect(Collectors.toList());
    }

    public static List<ItemStack> getInputItems(GTRecipe recipe) {
        return recipe.getInputContents(ItemRecipeCapability.CAP).stream().map(content -> (Ingredient)ItemRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getItems()[0]).collect(Collectors.toList());
    }

    public static List<FluidStack> getInputFluids(GTRecipe recipe) {
        return recipe.getInputContents(FluidRecipeCapability.CAP).stream().map(content -> (FluidIngredient)FluidRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getStacks()[0]).collect(Collectors.toList());
    }

    public static List<ItemStack> getOutputItems(GTRecipe recipe) {
        return recipe.getOutputContents(ItemRecipeCapability.CAP).stream().map(content -> (Ingredient)ItemRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getItems()[0]).collect(Collectors.toList());
    }

    public static List<ItemStack> getOutputItems(GTRecipeBuilder builder) {
        return builder.output.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList()).stream().map(content -> (Ingredient)ItemRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getItems()[0]).collect(Collectors.toList());
    }

    public static List<FluidStack> getOutputFluids(GTRecipe recipe) {
        return recipe.getOutputContents(FluidRecipeCapability.CAP).stream().map(content -> (FluidIngredient)FluidRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getStacks()[0]).collect(Collectors.toList());
    }

    public static List<FluidStack> getOutputFluids(GTRecipeBuilder builder) {
        return builder.output.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).stream().map(content -> (FluidIngredient)FluidRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getStacks()[0]).collect(Collectors.toList());
    }

    public static ActionResult matchRecipe(IRecipeCapabilityHolder holder, GTRecipe recipe) {
        return RecipeHelper.matchRecipe(holder, recipe, false);
    }

    public static ActionResult matchTickRecipe(IRecipeCapabilityHolder holder, GTRecipe recipe) {
        return recipe.hasTick() ? RecipeHelper.matchRecipe(holder, recipe, true) : ActionResult.SUCCESS;
    }

    private static ActionResult matchRecipe(IRecipeCapabilityHolder holder, GTRecipe recipe, boolean tick) {
        if (!holder.hasCapabilityProxies()) {
            return ActionResult.FAIL_NO_CAPABILITIES;
        }
        ActionResult result = RecipeHelper.handleRecipe(holder, recipe, IO.IN, tick ? recipe.tickInputs : recipe.inputs, Collections.emptyMap(), tick, true);
        if (!result.isSuccess()) {
            return result;
        }
        result = RecipeHelper.handleRecipe(holder, recipe, IO.OUT, tick ? recipe.tickOutputs : recipe.outputs, Collections.emptyMap(), tick, true);
        return result;
    }

    public static ActionResult handleRecipeIO(IRecipeCapabilityHolder holder, GTRecipe recipe, IO io, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches) {
        if (!holder.hasCapabilityProxies() || io == IO.BOTH) {
            return ActionResult.FAIL_NO_CAPABILITIES;
        }
        return RecipeHelper.handleRecipe(holder, recipe, io, io == IO.IN ? recipe.inputs : recipe.outputs, chanceCaches, false, false);
    }

    public static ActionResult handleTickRecipeIO(IRecipeCapabilityHolder holder, GTRecipe recipe, IO io, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches) {
        if (!holder.hasCapabilityProxies() || io == IO.BOTH) {
            return ActionResult.FAIL_NO_CAPABILITIES;
        }
        return RecipeHelper.handleRecipe(holder, recipe, io, io == IO.IN ? recipe.tickInputs : recipe.tickOutputs, chanceCaches, true, false);
    }

    public static ActionResult handleRecipe(IRecipeCapabilityHolder holder, GTRecipe recipe, IO io, Map<RecipeCapability<?>, List<Content>> contents, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches, boolean isTick, boolean simulated) {
        RecipeRunner runner = new RecipeRunner(recipe, io, isTick, holder, chanceCaches, simulated);
        ActionResult result = runner.handle(contents);
        if (result.isSuccess() || result.capability() == null) {
            return result;
        }
        if (!simulated && ConfigHolder.INSTANCE.dev.debug) {
            GTCEu.LOGGER.warn("IO {} Error while handling recipe {} outputs for {}", (Object)Component.translatable((String)io.tooltip).getString(), (Object)recipe, (Object)holder);
        }
        String key = "gtceu.recipe_logic.insufficient_" + (io == IO.IN ? "in" : "out");
        return ActionResult.fail((Component)Component.translatable((String)key).append(": ").append((Component)result.capability().getName()), result.capability(), io);
    }

    public static ActionResult matchContents(IRecipeCapabilityHolder holder, GTRecipe recipe) {
        ActionResult match = RecipeHelper.matchRecipe(holder, recipe);
        if (!match.isSuccess()) {
            return match;
        }
        return RecipeHelper.matchTickRecipe(holder, recipe);
    }

    public static ActionResult checkConditions(GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        if (recipe.conditions.isEmpty()) {
            return ActionResult.SUCCESS;
        }
        Reference2ObjectArrayMap or = new Reference2ObjectArrayMap();
        for (RecipeCondition condition : recipe.conditions) {
            if (condition.isOr()) {
                or.computeIfAbsent(condition.getType(), type -> new ArrayList()).add(condition);
                continue;
            }
            if (condition.check(recipe, recipeLogic)) continue;
            return ActionResult.fail((Component)Component.translatable((String)"gtceu.recipe_logic.condition_fails").append(": ").append(condition.getTooltips()), null, null);
        }
        for (List conditions : or.values()) {
            RecipeCondition condition;
            boolean passed = conditions.isEmpty();
            MutableComponent component = Component.translatable((String)"gtceu.recipe_logic.condition_fails").append(": ");
            Iterator iterator = conditions.iterator();
            while (iterator.hasNext() && !(passed = (condition = (RecipeCondition)iterator.next()).check(recipe, recipeLogic))) {
                component.append(condition.getTooltips());
            }
            if (passed) continue;
            return ActionResult.fail((Component)component, null, null);
        }
        return ActionResult.SUCCESS;
    }

    @Contract(pure=true)
    public static GTRecipe trimRecipeOutputs(GTRecipe recipe, Reference2IntMap<RecipeCapability<?>> trimLimits) {
        if (trimLimits.isEmpty() || trimLimits.values().intStream().allMatch(integer -> integer == -1)) {
            return recipe;
        }
        GTRecipe copy = recipe.copy();
        copy.outputs.clear();
        copy.outputs.putAll(RecipeHelper.doTrim(recipe.outputs, trimLimits));
        copy.tickOutputs.clear();
        copy.tickOutputs.putAll(RecipeHelper.doTrim(recipe.tickOutputs, trimLimits));
        return copy;
    }

    @Contract(pure=true)
    public static Map<RecipeCapability<?>, List<Content>> doTrim(Map<RecipeCapability<?>, List<Content>> current, Reference2IntMap<RecipeCapability<?>> trimLimits) {
        Reference2ObjectOpenHashMap outputs = new Reference2ObjectOpenHashMap(current.size());
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : current.entrySet()) {
            int N;
            RecipeCapability<?> cap = entry.getKey();
            List<Content> contents = entry.getValue();
            if (contents.isEmpty() || (N = trimLimits.getOrDefault(cap, -1)) == 0) continue;
            List list = outputs.computeIfAbsent(cap, c -> new ArrayList());
            if (N == -1) {
                list.addAll(contents);
                continue;
            }
            int added = 0;
            ArrayList<Content> chanced = new ArrayList<Content>();
            for (Content content : contents) {
                if (added == N) break;
                if (0 < content.chance && content.chance < content.maxChance) {
                    chanced.add(content);
                    continue;
                }
                list.add(content);
                ++added;
            }
            if (added >= N) continue;
            int rem = Math.min(chanced.size(), N - added);
            list.addAll(chanced.subList(0, rem));
        }
        return outputs;
    }

    public static void addToRecipeHandlerMap(RecipeHandlerGroup key, RecipeHandlerList handler, Map<RecipeHandlerGroup, List<RecipeHandlerList>> map) {
        if (handler.doesCapabilityBypassDistinct()) {
            map.computeIfAbsent(RecipeHandlerGroupDistinctness.BYPASS_DISTINCT, $ -> new ArrayList()).add(handler);
            return;
        }
        if (key.equals(RecipeHandlerGroupColor.UNDYED)) {
            for (Map.Entry<RecipeHandlerGroup, List<RecipeHandlerList>> entry : map.entrySet()) {
                if (entry.getKey().equals(RecipeHandlerGroupDistinctness.BUS_DISTINCT) || entry.getKey().equals(RecipeHandlerGroupDistinctness.BYPASS_DISTINCT) || entry.getKey().equals(RecipeHandlerGroupColor.UNDYED)) continue;
                entry.getValue().add(handler);
            }
        }
        List undyed = map.getOrDefault(RecipeHandlerGroupColor.UNDYED, Collections.emptyList());
        map.computeIfAbsent(key, $ -> new ArrayList(undyed)).add(handler);
    }

    public static int getRatioForDistillery(FluidIngredient fluidInput, FluidIngredient fluidOutput, @Nullable ItemStack output) {
        int[] divisors = new int[]{2, 5, 10, 25, 50};
        int ratio = -1;
        for (int divisor : divisors) {
            if (!RecipeHelper.isFluidStackDivisibleForDistillery(fluidInput, divisor) || !RecipeHelper.isFluidStackDivisibleForDistillery(fluidOutput, divisor) || output != null && output.getCount() % divisor != 0) continue;
            ratio = divisor;
        }
        return Math.max(1, ratio);
    }

    public static boolean isFluidStackDivisibleForDistillery(FluidIngredient fluidStack, int divisor) {
        return fluidStack.getAmount() % divisor == 0 && fluidStack.getAmount() / divisor >= 25;
    }
}

