/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidContainerIngredient;
import com.gregtechceu.gtceu.core.mixins.ShapedRecipeAccessor;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class ShapedFluidContainerRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<ShapedFluidContainerRecipe> SERIALIZER = new Serializer();

    public ShapedFluidContainerRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result, boolean showNotification) {
        super(id, group, category, width, height, recipeItems, result, showNotification);
    }

    public ShapedFluidContainerRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        this(id, group, category, width, height, recipeItems, result, true);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        NonNullList items = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        int replacedSlot = -1;
        block0: for (int x = 0; x <= inv.getWidth() - this.getWidth(); ++x) {
            for (int y = 0; y <= inv.getHeight() - this.getHeight(); ++y) {
                IntObjectPair<ItemStack> stack = this.findFluidReplacement(inv, x, y, false);
                if (stack.firstInt() != -1) {
                    items.set(stack.firstInt(), (Object)((ItemStack)stack.second()));
                    replacedSlot = stack.firstInt();
                    break block0;
                }
                stack = this.findFluidReplacement(inv, x, y, true);
                if (stack.firstInt() == -1) continue;
                items.set(stack.firstInt(), (Object)((ItemStack)stack.second()));
                replacedSlot = stack.firstInt();
                break block0;
            }
        }
        for (int i = 0; i < items.size(); ++i) {
            ItemStack item;
            if (i == replacedSlot || !(item = inv.getItem(i)).hasCraftingRemainingItem()) continue;
            items.set(i, (Object)item.getCraftingRemainingItem());
        }
        return items;
    }

    private IntObjectPair<ItemStack> findFluidReplacement(CraftingContainer inv, int width, int height, boolean mirrored) {
        for (int x = 0; x < inv.getWidth(); ++x) {
            for (int y = 0; y < inv.getHeight(); ++y) {
                int slot;
                ItemStack stack;
                FluidContainerIngredient fluidContainerIngredient;
                int offsetX = x - width;
                int offsetY = y - height;
                Ingredient ingredient = Ingredient.EMPTY;
                if (offsetX >= 0 && offsetY >= 0 && offsetX < this.getWidth() && offsetY < this.getHeight()) {
                    ingredient = mirrored ? (Ingredient)this.getIngredients().get(this.getWidth() - offsetX - 1 + offsetY * this.getWidth()) : (Ingredient)this.getIngredients().get(offsetX + offsetY * this.getWidth());
                }
                if (!(ingredient instanceof FluidContainerIngredient) || !(fluidContainerIngredient = (FluidContainerIngredient)ingredient).test(stack = inv.getItem(slot = x + y * inv.getWidth()))) continue;
                return IntObjectPair.of((int)slot, (Object)fluidContainerIngredient.getExtractedStack(stack));
            }
        }
        return IntObjectPair.of((int)-1, (Object)ItemStack.EMPTY);
    }

    public static class Serializer
    implements RecipeSerializer<ShapedFluidContainerRecipe> {
        public ShapedFluidContainerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.getAsString((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.CODEC.byName(GsonHelper.getAsString((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> key = ShapedRecipeAccessor.callKeyFromJson(GsonHelper.getAsJsonObject((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipeAccessor.callShrink(ShapedRecipeAccessor.callPatternFromJson(GsonHelper.getAsJsonArray((JsonObject)json, (String)"pattern")));
            int xSize = pattern[0].length();
            int ySize = pattern.length;
            NonNullList<Ingredient> dissolved = ShapedRecipeAccessor.callDissolvePattern(pattern, key, xSize, ySize);
            ItemStack result = ShapedFluidContainerRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            boolean showNotification = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_notification", (boolean)true);
            return new ShapedFluidContainerRecipe(recipeId, group, category, xSize, ySize, dissolved, result, showNotification);
        }

        public ShapedFluidContainerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int xSize = buffer.readVarInt();
            int ySize = buffer.readVarInt();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            String group = buffer.readUtf();
            NonNullList ingredients = NonNullList.withSize((int)(xSize * ySize), (Object)Ingredient.EMPTY);
            ingredients.replaceAll($ -> Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            ItemStack result = buffer.readItem();
            boolean showNotification = buffer.readBoolean();
            return new ShapedFluidContainerRecipe(recipeId, group, category, xSize, ySize, (NonNullList<Ingredient>)ingredients, result, showNotification);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedFluidContainerRecipe recipe) {
            buffer.writeVarInt(recipe.getWidth());
            buffer.writeVarInt(recipe.getHeight());
            buffer.writeEnum((Enum)recipe.category());
            buffer.writeUtf(recipe.getGroup());
            for (Ingredient ingredient : recipe.getIngredients()) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeItem(((ShapedRecipeAccessor)((Object)recipe)).getResult());
            buffer.writeBoolean(recipe.showNotification());
        }
    }
}

