/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.core.mixins.ShapedRecipeAccessor;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StrictShapedRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<StrictShapedRecipe> SERIALIZER = new Serializer();

    public StrictShapedRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id, group, category, width, height, recipeItems, result);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        for (int i = 0; i <= inv.getWidth() - this.getWidth(); ++i) {
            for (int j = 0; j <= inv.getHeight() - this.getHeight(); ++j) {
                if (!this.matches(inv, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer craftingInventory, int width, int height) {
        for (int i = 0; i < craftingInventory.getWidth(); ++i) {
            for (int j = 0; j < craftingInventory.getHeight(); ++j) {
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.EMPTY;
                if (k >= 0 && l >= 0 && k < this.getWidth() && l < this.getHeight()) {
                    ingredient = (Ingredient)this.getIngredients().get(k + l * this.getWidth());
                }
                if (ingredient.test(craftingInventory.getItem(i + j * craftingInventory.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<StrictShapedRecipe> {
        public StrictShapedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.getAsString((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)CraftingBookCategory.CODEC.byName(GsonHelper.getAsString((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> map = ShapedRecipeAccessor.callKeyFromJson(GsonHelper.getAsJsonObject((JsonObject)json, (String)"key"));
            String[] strings = ShapedRecipeAccessor.callPatternFromJson(GsonHelper.getAsJsonArray((JsonObject)json, (String)"pattern"));
            int i = strings[0].length();
            int j = strings.length;
            NonNullList<Ingredient> nonNullList = ShapedRecipeAccessor.callDissolvePattern(strings, map, i, j);
            ItemStack itemStack = StrictShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            return new StrictShapedRecipe(recipeId, string, craftingBookCategory, i, j, nonNullList, itemStack);
        }

        public StrictShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.readVarInt();
            int j = buffer.readVarInt();
            String string = buffer.readUtf();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            NonNullList nonNullList = NonNullList.withSize((int)(i * j), (Object)Ingredient.EMPTY);
            nonNullList.replaceAll(ignored -> Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            ItemStack itemStack = buffer.readItem();
            return new StrictShapedRecipe(recipeId, string, craftingBookCategory, i, j, (NonNullList<Ingredient>)nonNullList, itemStack);
        }

        public void toNetwork(FriendlyByteBuf buffer, StrictShapedRecipe recipe) {
            buffer.writeVarInt(recipe.getWidth());
            buffer.writeVarInt(recipe.getHeight());
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            for (Ingredient ingredient : recipe.getIngredients()) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeItem(((ShapedRecipeAccessor)((Object)recipe)).getResult());
        }
    }
}

