/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SerializerIngredient
implements IContentSerializer<Ingredient> {
    public static final Codec<Ingredient> CODEC = ExtraCodecs.JSON.xmap(Ingredient::fromJson, Ingredient::toJson);
    public static SerializerIngredient INSTANCE = new SerializerIngredient();

    private SerializerIngredient() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, Ingredient content) {
        content.toNetwork(buf);
    }

    @Override
    public Ingredient fromNetwork(FriendlyByteBuf buf) {
        return Ingredient.fromNetwork((FriendlyByteBuf)buf);
    }

    @Override
    public Ingredient fromJson(JsonElement json) {
        return Ingredient.fromJson((JsonElement)json);
    }

    @Override
    public JsonElement toJson(Ingredient content) {
        return content.toJson();
    }

    @Override
    public Ingredient of(Object o) {
        if (o instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)o;
            return ingredient;
        }
        if (o instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)o;
            return SizedIngredient.create(itemStack);
        }
        if (o instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)o;
            return Ingredient.of((ItemLike[])new ItemLike[]{itemLike});
        }
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            return Ingredient.of((TagKey)tag);
        }
        return Ingredient.EMPTY;
    }

    @Override
    public Ingredient defaultValue() {
        return Ingredient.EMPTY;
    }

    @Override
    public Class<Ingredient> contentClass() {
        return Ingredient.class;
    }

    @Override
    public Codec<Ingredient> codec() {
        return CODEC;
    }
}

