/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicates;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.TrueNBTPredicate;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTPredicateIngredient
extends AbstractIngredient {
    public static final ResourceLocation TYPE = GTCEu.id("nbt_predicate");
    public static final NBTPredicate ALWAYS_TRUE = new TrueNBTPredicate();
    private final NBTPredicate predicate;
    private final ItemStack stack;

    public NBTPredicateIngredient(ItemStack stack, NBTPredicate predicate) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.stack = stack;
        this.predicate = predicate;
    }

    protected NBTPredicateIngredient(ItemStack stack) {
        this(stack, ALWAYS_TRUE);
    }

    public static NBTPredicateIngredient of(ItemStack stack, NBTPredicate predicate) {
        return new NBTPredicateIngredient(stack, predicate);
    }

    public static NBTPredicateIngredient of(ItemStack stack) {
        return NBTPredicateIngredient.of(stack, ALWAYS_TRUE);
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.stack.getItem() == input.getItem() && this.predicate.test(input.getOrCreateTag());
    }

    public boolean isSimple() {
        return false;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.stack.getItem()).toString());
        json.addProperty("count", (Number)this.stack.getCount());
        if (this.stack.hasTag()) {
            json.addProperty("nbt", this.stack.getTag().toString());
        }
        json.add("predicate", (JsonElement)this.predicate.toJson());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<NBTPredicateIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public NBTPredicateIngredient parse(FriendlyByteBuf buffer) {
            ItemStack stack = buffer.readItem();
            String json = buffer.readUtf();
            NBTPredicate predicate = NBTPredicates.fromJson(GsonHelper.parse((String)json));
            return new NBTPredicateIngredient(stack, predicate);
        }

        @NotNull
        public NBTPredicateIngredient parse(@NotNull JsonObject json) {
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            NBTPredicate predicate = NBTPredicates.fromJson(GsonHelper.getAsJsonObject((JsonObject)json, (String)"predicate"));
            return new NBTPredicateIngredient(stack, predicate);
        }

        public void write(FriendlyByteBuf buffer, NBTPredicateIngredient ingredient) {
            buffer.writeItem(ingredient.stack);
            buffer.writeUtf(ingredient.toJson().toString());
        }
    }
}

