/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicateUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;

public class ComparisonNBTPredicate
extends NBTPredicate {
    public static final String TYPE = "compare";
    private final String key;
    private final double value;
    private final boolean lessThan;
    private final boolean equals;

    @Override
    public String getType() {
        return TYPE;
    }

    public ComparisonNBTPredicate(String key, double value) {
        this(key, value, false, false);
    }

    public ComparisonNBTPredicate(String key, double value, boolean lessThan, boolean equals) {
        this.key = key;
        this.value = value;
        this.lessThan = lessThan;
        this.equals = equals;
    }

    @Override
    public boolean test(CompoundTag tag) {
        Tag toCompare = NBTPredicateUtils.getNestedTag(tag, this.key);
        if (toCompare != null && toCompare instanceof NumericTag) {
            NumericTag toCompareNum = (NumericTag)toCompare;
            if (this.equals && toCompareNum.getAsDouble() == this.value) {
                return true;
            }
            if (this.lessThan) {
                return toCompareNum.getAsDouble() < this.value;
            }
            return toCompareNum.getAsDouble() > this.value;
        }
        return false;
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = super.toJson();
        object.addProperty("key", this.key);
        object.addProperty("value", (Number)this.value);
        object.addProperty("lessThan", Boolean.valueOf(this.lessThan));
        object.addProperty("equals", Boolean.valueOf(this.equals));
        return object;
    }

    public static NBTPredicate fromJson(JsonObject json) {
        if (!(json.has("key") && json.has("value") && json.has("lessThan") && json.has("equals") && json.has("type"))) {
            throw new IllegalStateException("Could not deserialize ComparisonNBTPredicate: " + String.valueOf(json));
        }
        if (!json.get("type").getAsString().equals(TYPE)) {
            throw new IllegalStateException("Trying to deserialize ComparisonNBTPredicate but was something else: " + String.valueOf(json));
        }
        String key = json.get("key").getAsString();
        double value = json.get("value").getAsDouble();
        boolean lessThan = json.get("lessThan").getAsBoolean();
        boolean equals = json.get("equals").getAsBoolean();
        return new ComparisonNBTPredicate(key, value, lessThan, equals);
    }

    public String toString() {
        return "ComparisonNBTPredicate{key='" + this.key + "', value=" + this.value + ", lessThan=" + this.lessThan + ", equals=" + this.equals + "}";
    }
}

