/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicateUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;

public class EqualsNBTPredicate
extends NBTPredicate {
    public static final String TYPE = "equals";
    private final String key;
    private final Tag value;
    private final boolean inverted;

    @Override
    public String getType() {
        return TYPE;
    }

    public EqualsNBTPredicate(String key, Tag value) {
        this(key, value, false);
    }

    public EqualsNBTPredicate(String key, Tag value, boolean inverted) {
        this.key = key;
        this.value = value;
        this.inverted = inverted;
    }

    @Override
    public boolean test(CompoundTag tag) {
        Tag toCompare = NBTPredicateUtils.getNestedTag(tag, this.key);
        if (toCompare == null) {
            return false;
        }
        if (toCompare instanceof NumericTag) {
            NumericTag toCompareNum = (NumericTag)toCompare;
            Tag tag2 = this.value;
            if (tag2 instanceof NumericTag) {
                NumericTag valueNum = (NumericTag)tag2;
                return this.inverted ^ toCompareNum.getAsDouble() == valueNum.getAsDouble();
            }
        }
        return this.inverted ^ toCompare.equals(this.value);
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = super.toJson();
        object.addProperty("key", this.key);
        object.add("value", NBTPredicateUtils.toJson(this.value));
        object.addProperty("inverted", Boolean.valueOf(this.inverted));
        return object;
    }

    public static NBTPredicate fromJson(JsonObject json) {
        if (!(json.has("key") && json.has("value") && json.has("type"))) {
            throw new IllegalStateException("Could not deserialize EqualsNBTPredicate: " + String.valueOf(json));
        }
        if (!json.get("type").getAsString().equals(TYPE)) {
            throw new IllegalStateException("Trying to deserialize EqualsNBTPredicate but was something else: " + String.valueOf(json));
        }
        String key = json.get("key").getAsString();
        Tag value = NBTPredicateUtils.fromJson(json.get("value"));
        boolean inverted = false;
        if (json.has("inverted")) {
            inverted = json.get("inverted").getAsBoolean();
        }
        return new EqualsNBTPredicate(key, value, inverted);
    }

    public String toString() {
        return "EqualsNBTPredicate{key='" + this.key + "', value=" + String.valueOf(this.value) + ", inverted=" + this.inverted + "}";
    }
}

