/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicates;
import net.minecraft.nbt.CompoundTag;

public class NotNBTPredicate
extends NBTPredicate {
    public static final String TYPE = "not";
    private final NBTPredicate child;

    @Override
    public String getType() {
        return TYPE;
    }

    public NotNBTPredicate(NBTPredicate child) {
        this.child = child;
    }

    @Override
    public boolean test(CompoundTag tag) {
        return !this.child.test(tag);
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = super.toJson();
        object.add("child", (JsonElement)this.child.toJson());
        return object;
    }

    public static NBTPredicate fromJson(JsonObject json) {
        if (!json.has("child") || !json.has("type")) {
            throw new IllegalStateException("Could not deserialize NotNBTPredicate: " + String.valueOf(json));
        }
        if (!json.get("type").getAsString().equals(TYPE)) {
            throw new IllegalStateException("Trying to deserialize NotNBTPredicate but was something else: " + String.valueOf(json));
        }
        NBTPredicate child = NBTPredicates.fromJson(json.get("child").getAsJsonObject());
        return new NotNBTPredicate(child);
    }

    public String toString() {
        return "NotNBTPredicate{child=" + String.valueOf(this.child) + "}";
    }
}

