/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup.ingredient;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.MapIngredientFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapIngredientTypeManager {
    private static final Map<Class<?>, List<? extends MapIngredientFunction<?>>> ingredientFunctions = new ConcurrentHashMap(7);
    private static final Map<MapIngredientFunction<?>, Class<?>> ingredientTypes = new ConcurrentHashMap(7);
    private static final Map<Class<?>, Class<?>> WRAPPERS = (Map)Util.make(new HashMap(9), map -> {
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        map.put(Void.TYPE, Void.class);
    });

    public static <T> void registerMapIngredient(Class<T> ingredientClass, MapIngredientFunction<T> function) {
        ingredientClass = MapIngredientTypeManager.boxClass(ingredientClass);
        List list = ingredientFunctions.computeIfAbsent(ingredientClass, $ -> new ArrayList());
        list.add(function);
        ingredientTypes.put(function, ingredientClass);
    }

    @NotNull
    public static <T> List<AbstractMapIngredient> getFrom(T object, RecipeCapability<?> cap) {
        List<AbstractMapIngredient> defaults;
        Class objClass = MapIngredientTypeManager.boxClass(object.getClass());
        Class<Object> stopAt = MapIngredientTypeManager.boxClass(cap.serializer.contentClass());
        if (!stopAt.isAssignableFrom(objClass)) {
            stopAt = Object.class;
        }
        List<MapIngredientFunction<?>> functions = MapIngredientTypeManager.getTypesForClass(objClass, stopAt);
        if (!objClass.isAssignableFrom(stopAt) && (defaults = MapIngredientTypeManager.getDefaultIngredients(object, cap, stopAt, functions)) != null) {
            return defaults;
        }
        ArrayList<AbstractMapIngredient> values = new ArrayList<AbstractMapIngredient>();
        for (MapIngredientFunction<?> function : functions) {
            values.addAll(function.getIngredients(object));
        }
        return values;
    }

    private static <T> List<? extends MapIngredientFunction<? super T>> getTypesForClass(Class<T> objClass, Class<?> stopAt) {
        Preconditions.checkArgument((boolean)stopAt.isAssignableFrom(objClass), (String)"stopAt must be a superclass of %s", objClass);
        List<? extends MapIngredientFunction<?>> types = ingredientFunctions.get(objClass);
        if (types == null && objClass != stopAt) {
            Class<T> superclass = objClass.getSuperclass();
            if (superclass == null || superclass == stopAt) {
                return Collections.emptyList();
            }
            return MapIngredientTypeManager.getTypesForClass(superclass, stopAt);
        }
        return types;
    }

    @Nullable
    private static <T> List<AbstractMapIngredient> getDefaultIngredients(T object, RecipeCapability<?> cap, Class<?> stopAt, List<? extends MapIngredientFunction<? super T>> functions) {
        for (MapIngredientFunction<T> mapIngredientFunction : functions) {
            if (ingredientTypes.get(mapIngredientFunction) == stopAt) continue;
            return null;
        }
        return Objects.requireNonNullElseGet(cap.getDefaultMapIngredient(object), Collections::emptyList);
    }

    @NotNull
    private static <T> Class<T> boxClass(Class<T> clazz) {
        return WRAPPERS.getOrDefault(clazz, clazz);
    }
}

