/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup.ingredient.item;

import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class CustomMapIngredient
extends AbstractMapIngredient {
    protected ItemStack stack;
    protected Ingredient ingredient = null;

    public CustomMapIngredient(ItemStack stack) {
        this.stack = stack;
    }

    public CustomMapIngredient(ItemStack stack, Ingredient ingredient) {
        this.stack = stack;
        this.ingredient = ingredient;
    }

    public static List<AbstractMapIngredient> from(Ingredient ingredient) {
        ItemStack[] stacks;
        ArrayList<AbstractMapIngredient> ingredients = new ArrayList<AbstractMapIngredient>();
        for (ItemStack stack : stacks = ingredient.getItems()) {
            ingredients.add(new CustomMapIngredient(stack, ingredient));
        }
        return ingredients;
    }

    @NotNull
    public static List<AbstractMapIngredient> from(ItemStack stack) {
        return Collections.singletonList(new CustomMapIngredient(stack));
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            CustomMapIngredient other = (CustomMapIngredient)o;
            if (!ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)other.stack)) {
                return false;
            }
            if (this.ingredient != null) {
                if (other.ingredient != null) {
                    for (ItemStack stack : other.ingredient.getItems()) {
                        if (this.ingredient.test(stack)) continue;
                        return false;
                    }
                    for (ItemStack stack : this.ingredient.getItems()) {
                        if (other.ingredient.test(stack)) continue;
                        return false;
                    }
                    return true;
                }
                return this.ingredient.test(other.stack);
            }
            if (other.ingredient != null) {
                return other.ingredient.test(this.stack);
            }
        }
        return false;
    }

    @Override
    protected int hash() {
        return this.stack.getItem().hashCode() * 31;
    }

    public String toString() {
        return "CustomMapIngredient{item=" + String.valueOf(this.stack) + "ingredient=" + String.valueOf(this.ingredient) + "}";
    }

    @Override
    public boolean isSpecialIngredient() {
        return true;
    }
}

