/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup.ingredient.item;

import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.item.ItemStackMapIngredient;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import org.jetbrains.annotations.NotNull;

public class PartialNBTItemStackMapIngredient
extends ItemStackMapIngredient {
    protected PartialNBTIngredient nbtIngredient;

    public PartialNBTItemStackMapIngredient(ItemStack stack, PartialNBTIngredient nbtIngredient) {
        super(stack, (Ingredient)nbtIngredient);
        this.nbtIngredient = nbtIngredient;
    }

    @NotNull
    public static List<AbstractMapIngredient> from(@NotNull PartialNBTIngredient ingredient) {
        ObjectArrayList list = new ObjectArrayList();
        for (ItemStack s : ingredient.getItems()) {
            list.add((Object)new PartialNBTItemStackMapIngredient(s, ingredient));
        }
        return list;
    }

    @NotNull
    public static List<AbstractMapIngredient> from(@NotNull ItemStack stack) {
        if (stack.getShareTag() != null) {
            return Collections.singletonList(new PartialNBTItemStackMapIngredient(stack, PartialNBTIngredient.of((ItemLike)stack.getItem(), (CompoundTag)stack.getShareTag())));
        }
        return Collections.emptyList();
    }

    @Override
    protected int hash() {
        return ItemStackHashStrategy.comparingItem().hashCode(this.stack) * 31;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PartialNBTItemStackMapIngredient) {
            PartialNBTItemStackMapIngredient other = (PartialNBTItemStackMapIngredient)obj;
            if (this.stack.getItem() != other.stack.getItem()) {
                return false;
            }
            if (this.nbtIngredient != null) {
                if (other.nbtIngredient != null) {
                    if (this.nbtIngredient.getItems().length != other.nbtIngredient.getItems().length) {
                        return false;
                    }
                    for (ItemStack stack : this.nbtIngredient.getItems()) {
                        if (other.nbtIngredient.test(stack)) continue;
                        return false;
                    }
                    return true;
                }
                this.nbtIngredient.test(other.stack);
            } else if (other.nbtIngredient != null) {
                return other.nbtIngredient.test(this.stack);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "PartialNBTItemStackMapIngredient{item=" + String.valueOf(this.stack) + "}";
    }

    @Override
    public boolean isSpecialIngredient() {
        return true;
    }
}

