/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.sound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CustomSoundEntry
extends SoundEntry {
    protected List<ResourceLocation> variants;
    protected SoundEvent event;

    public CustomSoundEntry(ResourceLocation id, List<ResourceLocation> variants, String subtitle, SoundSource category, int attenuationDistance) {
        super(id, subtitle, category, attenuationDistance);
        this.variants = variants;
    }

    @Override
    public void prepare() {
        this.event = SoundEvent.createVariableRangeEvent((ResourceLocation)this.id);
    }

    @Override
    public void register(Consumer<SoundEvent> registry) {
        registry.accept(this.event);
    }

    @Override
    public SoundEvent getMainEvent() {
        return this.event;
    }

    @Override
    public void write(JsonObject json) {
        JsonObject entry = new JsonObject();
        JsonArray list = new JsonArray();
        JsonObject s = new JsonObject();
        s.addProperty("name", this.id.toString());
        s.addProperty("type", "file");
        if (this.attenuationDistance != 0) {
            s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
        }
        list.add((JsonElement)s);
        for (ResourceLocation variant : this.variants) {
            s = new JsonObject();
            s.addProperty("name", variant.toString());
            s.addProperty("type", "file");
            if (this.attenuationDistance != 0) {
                s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            list.add((JsonElement)s);
        }
        entry.add("sounds", (JsonElement)list);
        if (this.hasSubtitle()) {
            entry.addProperty("subtitle", this.getSubtitleKey());
        }
        json.add(this.id.getPath(), (JsonElement)entry);
    }

    @Override
    public void play(Level world, Player entity, double x, double y, double z, float volume, float pitch) {
        world.playSound(entity, x, y, z, this.event, this.category, volume, pitch);
    }

    @Override
    public void playAt(Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
        world.playLocalSound(x, y, z, this.event, this.category, volume, pitch, fade);
    }
}

