/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine.multipart;

import com.google.common.base.Splitter;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.model.machine.multipart.PartCondition;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class KeyValuePartCondition
implements PartCondition {
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').omitEmptyStrings();
    private final String key;
    private final String value;

    public KeyValuePartCondition(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public Predicate<MachineRenderState> getPredicate(StateDefinition<MachineDefinition, MachineRenderState> def) {
        Predicate<MachineRenderState> predicate;
        List unparsedPredicates;
        boolean invert;
        Property property = def.getProperty(this.key);
        if (property == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "Unknown property '%s' on machine '%s'", this.key, def.getOwner()));
        }
        String value = this.value;
        boolean bl = invert = !value.isEmpty() && value.charAt(0) == '!';
        if (invert) {
            value = value.substring(1);
        }
        if ((unparsedPredicates = PIPE_SPLITTER.splitToList((CharSequence)value)).isEmpty()) {
            throw new RuntimeException(String.format(Locale.ROOT, "Empty value '%s' for property '%s' on machine '%s'", this.value, this.key, def.getOwner()));
        }
        if (unparsedPredicates.size() == 1) {
            predicate = this.getStatePredicate(def, property, value);
        } else {
            List<Predicate> parsed = unparsedPredicates.stream().map(string -> this.getStatePredicate(def, (Property<?>)property, (String)string)).toList();
            predicate = state -> parsed.stream().anyMatch(p -> p.test(state));
        }
        return invert ? predicate.negate() : predicate;
    }

    private Predicate<MachineRenderState> getStatePredicate(StateDefinition<MachineDefinition, MachineRenderState> def, Property<?> property, String value) {
        Optional optional = property.getValue(value);
        if (optional.isEmpty()) {
            throw new RuntimeException(String.format(Locale.ROOT, "Unknown value '%s' for property '%s' on '%s' in '%s'", value, this.key, def.getOwner(), this.value));
        }
        return state -> state.getValue(property).equals(optional.get());
    }

    public String toString() {
        return "KeyValueCondition{key='" + this.key + "', value='" + this.value + "'}";
    }
}

