/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine.variant;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.client.model.machine.variant.VariantState;
import com.mojang.math.Transformation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.SimpleModelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MultiVariantModel(List<VariantState> variants) implements UnbakedModel
{
    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MultiVariantModel) {
            MultiVariantModel model = (MultiVariantModel)other;
            return this.variants.equals(model.variants);
        }
        return false;
    }

    @NotNull
    public Collection<ResourceLocation> getDependencies() {
        return this.variants.stream().map(VariantState::getModel).flatMap(either -> (Stream)either.map(Stream::of, model -> model.getDependencies().stream())).collect(Collectors.toSet());
    }

    public void resolveParents(@NotNull Function<ResourceLocation, UnbakedModel> resolver) {
        this.variants.forEach(variant -> {
            UnbakedModel model = (UnbakedModel)variant.getModel().map(resolver, Function.identity());
            variant.setResolvedModel(model);
            model.resolveParents(resolver);
        });
    }

    @Nullable
    public BakedModel bake(@NotNull ModelBaker baker, @NotNull Function<Material, TextureAtlasSprite> spriteGetter, @NotNull ModelState state, @NotNull ResourceLocation location) {
        if (this.variants.isEmpty()) {
            return null;
        }
        WeightedBakedModel.Builder weightedBuilder = new WeightedBakedModel.Builder();
        for (VariantState variant : this.variants) {
            Transformation actualRotation = state.getRotation().compose(variant.getRotation());
            SimpleModelState actualState = new SimpleModelState(actualRotation, variant.isUvLocked());
            BakedModel baked = variant.getResolvedModel().bake(baker, spriteGetter, (ModelState)actualState, (ResourceLocation)variant.getModel().map(Function.identity(), model -> location));
            weightedBuilder.add(baked, variant.getWeight());
        }
        return weightedBuilder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<MultiVariantModel> {
        public MultiVariantModel deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<VariantState> variants = new ArrayList<VariantState>();
            if (json.isJsonArray()) {
                JsonArray array = json.getAsJsonArray();
                if (array.isEmpty()) {
                    throw new JsonParseException("Empty variant array");
                }
                for (JsonElement v : array) {
                    variants.add((VariantState)context.deserialize(v, VariantState.class));
                }
            } else {
                variants.add((VariantState)context.deserialize(json, VariantState.class));
            }
            return new MultiVariantModel(variants);
        }
    }
}

